package com.digiwin.athena.appcore.auth.domain;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 登陆后的对象
 * 与原来 com.digiwin.athena.appcore.auth.domain.AuthoredUser 对象保持一致
 *
 * @author gengwei
 * @since 2024/8/19 10:46
 */
public class AuthoredUser {
    private long sid;
    @JsonProperty("id")
    private String userId;
    @JsonProperty("name")
    private String userName;
    private long tenantSid;
    private String tenantId;
    private String tenantName;
    private String token;
    //登录人员身份
    private String identityType;
    private List<IamGrantedAuthority> roles;
    private String version;

    public AuthoredUser() {
        roles = new ArrayList<>();
    }


    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AuthoredUser) {
            AuthoredUser test = (AuthoredUser) obj;
            //只要认为用户sid和租户sid相等，就可以认为相等
            if (this.getSid() == test.getSid() && this.getTenantSid() == test.getTenantSid()) {
                return true;
            }
        }

        return false;
    }

    @Override
    public int hashCode() {
        return (int) (sid ^ tenantSid);
    }

    public long getSid() {
        return sid;
    }

    public void setSid(long sid) {
        this.sid = sid;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public List<IamGrantedAuthority> getRoles() {
        return roles;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
