/*
 * Copyright (c) 2019.  鼎捷软件股份有限公司.All rights reserved.
 */

package com.digiwin.athena.appcore.exception;

import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;
import com.jugg.agile.framework.meta.exception.JaBaseException;

import java.util.Map;
import java.util.Objects;

/**
 * Created by chenxsa on 2018-2-27.
 * 封装业务异常
 */
public class BusinessException extends JaBaseException {
    Integer code;

    /**
     * 状态码，如：200
     */
    private Integer status;

    /**
     * 状态码描述，如：OK
     */
    private String statusDescription;

    /**
     * 错误码，业务正常时为null
     */
    private String errorCode;

    /**
     * 错误码描述，业务正常时为null
     */
    private Object errorMessage;

    /**
     * 错误类型，不一定有值，如：System/Business/Unexpected，
     */
    private String errorType;

    /**
     * 错误响应时，包含调用链信息：chainInfo
     */
    @Deprecated
    private Map<String, Object> errorInstructors;

    @Deprecated
    private String description;

    /**
     * 是否只是作为一个壳子、包含其他exception（即cause的值）；
     * 默认false：
     * true：则在GlobalExceptionHandler中将实际解析cause。
     */
    private boolean wrapper;

    /**
     * 针对iam校验token是否失效错误码，业务正常时为null
     */
    private String bizErrorCode;

    /**
     * 针对iam校验token是否失效错误码描述，业务正常时为null
     */
    private String bizErrorMsg;

    /**
     * esp 业务异常
     */
    private Map<String,Object> espError;

    /**
     * 创建异常
     *
     * @param code              http码
     * @param errorCode         业务错误码
     * @param errorMessage      业务错误信息
     * @param description       详细描述信息
     * @param statusDescription http码的说明
     * @param e                 内部错误
     * @return
     */
    public static BusinessException create(Integer code, String errorCode, Object errorMessage, String description, String statusDescription, Throwable e) {
        return BusinessException.create(500, errorCode, errorMessage, description, statusDescription, null, null);
    }

    /**
     * 创建异常
     *
     * @param code              http码
     * @param errorCode         业务错误码
     * @param errorMessage      业务错误信息
     * @param description       详细描述信息
     * @param statusDescription http码的说明
     * @param errorType         错误类型
     * @param e                 内部错误
     * @return
     */
    public static BusinessException create(Integer code, String errorCode, Object errorMessage, String description, String statusDescription, String errorType, Throwable e) {
        BusinessException businessException = new BusinessException(description, e);
        wrap(businessException, code, errorCode, errorMessage, description, statusDescription, errorType);
        return businessException;
    }


    public static void wrap(BusinessException businessException, Integer code, String errorCode, Object errorMessage, String description, String statusDescription, String errorType) {
        businessException.setCode(code);
        businessException.setErrorCode(errorCode);
        if (Objects.isNull(errorMessage)) {
            String local = JaI18nAdapter.getLocale();
            errorMessage = "页面出现异常，请联系客服！";
            if (Objects.equals(local, "zh_TW") || Objects.equals(local, "zh-TW")) {
                errorMessage = "頁面出現異常，請聯系客服！";
            }
            if (Objects.equals(local, "en_US") || Objects.equals(local, "en-US")) {
                errorMessage = "The page is abnormal, please contact customer service!";
            }
        }
        businessException.setErrorType(errorType);
        businessException.setErrorMessage(errorMessage);
        businessException.setDescription(description);
        businessException.setStatusDescription(statusDescription);
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public BusinessException() {
        super();
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public static BusinessException create(String message) {
        return BusinessException.create(500, null, message, message, "", null);
    }


    public static BusinessException create(Throwable cause) {
        return BusinessException.create(500, null, null, cause.getMessage(), "", cause);
    }


    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param code    error code;
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public static BusinessException create(Integer code, String message) {
        return BusinessException.create(code, code.toString(), message, message, "", null);
    }

    public static BusinessException create(String errorCode, String message) {
        return BusinessException.create(500, errorCode, message, message, "", null);
    }

    public static BusinessException create(String errorCode, String message, String errorType) {
        return BusinessException.create(500, errorCode, message, message, "", errorType, null);
    }

    public static BusinessException create(String errorCode, String message, String errorType, Throwable cause) {
        return BusinessException.create(500, errorCode, message, message, "", errorType, cause);
    }

    public static BusinessException create(String errorCode, String message, Throwable cause) {
        return BusinessException.create(500, errorCode, message, message, "", cause);
    }

    public static BusinessException create(Integer code, String errorCode, String message) {
        return BusinessException.create(code, errorCode, message, message, "", null);
    }

    public static BusinessException create(Integer code, String errorCode, String message, Throwable cause) {
        return BusinessException.create(code, errorCode, message, message, "", cause);
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime com.digiwin.middleware.core.exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public static BusinessException create(String message, Throwable cause) {
        return BusinessException.create(500, null, message, message, "", cause);
    }


    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime com.digiwin.middleware.core.exception's detail message.
     *
     * @param errorCode error code
     * @param message   the detail message (which is saved for later retrieval
     *                  by the {@link #getMessage()} method).
     * @param cause     the cause (which is saved for later retrieval by the
     *                  {@link #getCause()} method).  (A <tt>null</tt> value is
     *                  permitted, and indicates that the cause is nonexistent or
     *                  unknown.)
     * @since 1.4
     */
    public static BusinessException create(Integer errorCode, String message, Throwable cause) {
        return BusinessException.create(500, errorCode.toString(), message, message, "", cause);
    }

    public static BusinessException buildErrorCode(String errorCode) {
        BusinessException businessException = new BusinessException();
        businessException.setCode(500);
        businessException.setErrorCode(errorCode);
        return businessException;
    }

    public static BusinessException buildBizErrorCode(String errorCode) {
        BusinessException businessException = new BusinessException();
        businessException.setCode(500);
        businessException.setErrorCode(errorCode);
        businessException.setBizErrorCode(errorCode);
        return businessException;
    }

    /**
     * Constructs a new runtime com.digiwin.middleware.core.exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String errorCode, String errorMessage) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(String message) {
        super(message);
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isWrapper() {
        return wrapper;
    }

    public void setWrapper(boolean wrapper) {
        this.wrapper = wrapper;
    }

    @Deprecated
    public Map<String, Object> getErrorInstructors() {
        return errorInstructors;
    }

    @Deprecated
    public void setErrorInstructors(Map<String, Object> errorInstructors) {
        this.errorInstructors = errorInstructors;
    }

    public String getBizErrorCode() {
        return bizErrorCode;
    }

    public void setBizErrorCode(String bizErrorCode) {
        this.bizErrorCode = bizErrorCode;
    }

    public String getBizErrorMsg() {
        return bizErrorMsg;
    }

    public void setBizErrorMsg(String bizErrorMsg) {
        this.bizErrorMsg = bizErrorMsg;
    }

    public Map<String, Object> getEspError() {
        return espError;
    }

    public void setEspError(Map<String, Object> espError) {
        this.espError = espError;
    }
}
