package com.digiwin.athena.framework.multitx;

import org.springframework.transaction.TransactionStatus;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiTransactionContext {

    private final CountDownLatch mainDownLatch;
    private final CountDownLatch subDownLatch;
    private final AtomicBoolean rollBackFlag = new AtomicBoolean(false);
    private final Vector<Throwable> exceptionVector = new Vector<>();

    // 用于存储所有子线程的事务状态
    private final List<TransactionStatus> transactionStatuses = new ArrayList<>();

    public MultiTransactionContext(int subCount) {
        this.mainDownLatch = new CountDownLatch(1);
        this.subDownLatch = new CountDownLatch(subCount);
    }

    public CountDownLatch getMainDownLatch() {
        return mainDownLatch;
    }

    public CountDownLatch getSubDownLatch() {
        return subDownLatch;
    }

    public AtomicBoolean getRollBackFlag() {
        return rollBackFlag;
    }

    public Vector<Throwable> getExceptionVector() {
        return exceptionVector;
    }

    public void clear() {
        exceptionVector.clear();
    }

    // 获取子事务的事务状态列表
    public List<TransactionStatus> getTransactionStatuses() {
        return transactionStatuses;
    }
}
