/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.multitx;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.transaction.TransactionStatus;

public class MultiTransactionContext {
    private final CountDownLatch mainDownLatch;
    private final CountDownLatch subDownLatch;
    private final AtomicBoolean rollBackFlag = new AtomicBoolean(false);
    private final Vector<Throwable> exceptionVector = new Vector();
    private final List<TransactionStatus> transactionStatuses = new ArrayList<TransactionStatus>();

    public MultiTransactionContext(int subCount) {
        this.mainDownLatch = new CountDownLatch(1);
        this.subDownLatch = new CountDownLatch(subCount);
    }

    public CountDownLatch getMainDownLatch() {
        return this.mainDownLatch;
    }

    public CountDownLatch getSubDownLatch() {
        return this.subDownLatch;
    }

    public AtomicBoolean getRollBackFlag() {
        return this.rollBackFlag;
    }

    public Vector<Throwable> getExceptionVector() {
        return this.exceptionVector;
    }

    public void clear() {
        this.exceptionVector.clear();
    }

    public List<TransactionStatus> getTransactionStatuses() {
        return this.transactionStatuses;
    }
}

