/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.multitx;

import com.digiwin.athena.framework.multitx.MainTransaction;
import com.digiwin.athena.framework.multitx.MultiTransactionContext;
import com.digiwin.athena.framework.multitx.SubTransaction;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

@Aspect
@ConditionalOnProperty(prefix="athena.tx", name={"enable"}, havingValue="true")
public class TransactionAop {
    private static final Logger log = LoggerFactory.getLogger(TransactionAop.class);
    private static final Map<String, MultiTransactionContext> contextMap = new ConcurrentHashMap<String, MultiTransactionContext>();
    private static final JaThreadLocal<TransactionThreadContext> contextHolder = new JaThreadLocal();
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Around(value="@annotation(mainTransaction)")
    public void mainIntercept(ProceedingJoinPoint joinPoint, MainTransaction mainTransaction) throws Throwable {
        MultiTransactionContext context = this.preInitContext(mainTransaction);
        try {
            joinPoint.proceed();
        }
        catch (Throwable e) {
            context.getExceptionVector().add(0, e);
            context.getRollBackFlag().set(true);
        }
        context.getSubDownLatch().await();
        if (context.getRollBackFlag().get()) {
            context.getTransactionStatuses().forEach(arg_0 -> ((PlatformTransactionManager)this.transactionManager).rollback(arg_0));
        } else {
            context.getTransactionStatuses().forEach(arg_0 -> ((PlatformTransactionManager)this.transactionManager).commit(arg_0));
        }
        if (!CollectionUtils.isEmpty(context.getExceptionVector())) {
            contextMap.remove(Thread.currentThread().getName());
            contextHolder.remove();
            throw context.getExceptionVector().get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(subTransaction)")
    public void sonIntercept(ProceedingJoinPoint joinPoint, SubTransaction subTransaction) throws Throwable {
        TransactionThreadContext transactionThreadContext = (TransactionThreadContext)contextHolder.get();
        String threadName = transactionThreadContext == null ? "" : transactionThreadContext.getThreadName();
        MultiTransactionContext context = contextMap.get(threadName);
        if (context == null) {
            joinPoint.proceed();
            return;
        }
        CountDownLatch sonDownLatch = context.getSubDownLatch();
        AtomicBoolean rollBackFlag = context.getRollBackFlag();
        Vector<Throwable> exceptionVector = context.getExceptionVector();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            joinPoint.proceed();
            context.getTransactionStatuses().add(status);
        }
        catch (Throwable e) {
            exceptionVector.add(0, e);
            rollBackFlag.set(true);
        }
        finally {
            sonDownLatch.countDown();
        }
    }

    private MultiTransactionContext preInitContext(MainTransaction mainTransaction) {
        String threadName = Thread.currentThread().getName();
        MultiTransactionContext context = new MultiTransactionContext(mainTransaction.value());
        contextMap.put(threadName, context);
        TransactionThreadContext transactionThreadContext = new TransactionThreadContext();
        transactionThreadContext.setThreadName(threadName);
        contextHolder.set((Object)transactionThreadContext);
        return context;
    }

    static class TransactionThreadContext {
        private String threadName;

        TransactionThreadContext() {
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }
    }
}

