/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mybatisi18n.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nUtils {
    private static final Logger log = LoggerFactory.getLogger(I18nUtils.class);

    public static boolean isValidJson(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return Boolean.FALSE;
        }
        String jsonPattern = "\\A\\{.*}|\\[.*]}\\z";
        return jsonStr.trim().matches(jsonPattern);
    }

    public static String extractLocalizedValue(String json, String locale) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return json;
        }
        try {
            String jsonStr = StringEscapeUtils.unescapeJava((String)json);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            return jsonObject.getString(locale);
        }
        catch (Exception e) {
            log.warn("extractLocalizedValue error", (Throwable)e);
            return null;
        }
    }
}

