/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mybatisi18n;

import com.digiwin.athena.framework.mybatisi18n.JsonI18nFormatFor;
import com.digiwin.athena.framework.mybatisi18n.MybatisI18nContextHolder;
import com.jugg.agile.spring.boot.util.JaI18nUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonI18nFormatForParamResolver {
    public static final Map<String, String> selectorMap = new ConcurrentHashMap<String, String>();

    public static void resolver(String mapperMethodId, Object argObject) throws ClassNotFoundException {
        String localeSelector = selectorMap.getOrDefault(mapperMethodId, "");
        if (localeSelector.equals("context")) {
            JsonI18nFormatForParamResolver.executeThreadLanguage();
        } else if (localeSelector.equals("local")) {
            JsonI18nFormatForParamResolver.paramResolver(mapperMethodId, argObject);
        } else if (localeSelector.equals("none")) {
            JsonI18nFormatForParamResolver.methodResolver(mapperMethodId);
        } else {
            boolean isMatchSecond;
            boolean isMatch = JsonI18nFormatForParamResolver.paramResolver(mapperMethodId, argObject);
            if (!isMatch && !(isMatchSecond = JsonI18nFormatForParamResolver.methodResolver(mapperMethodId))) {
                selectorMap.putIfAbsent(mapperMethodId, "none");
            }
        }
    }

    public static boolean paramResolver(String mapperMethodId, Object argObject) throws ClassNotFoundException {
        String className = mapperMethodId.substring(0, mapperMethodId.lastIndexOf(46));
        String methodName = mapperMethodId.substring(mapperMethodId.lastIndexOf(46) + 1);
        Class<?> mapperClass = Class.forName(className);
        Method method = null;
        for (Method m : mapperClass.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            return Boolean.FALSE;
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; ++i) {
            for (Annotation annotation : paramAnnotations[i]) {
                Map paramMap;
                Object paramValue;
                if (!(annotation instanceof JsonI18nFormatFor) || !(argObject instanceof Map) || !((paramValue = (paramMap = (Map)argObject).get(method.getParameters()[i].getName())) instanceof Locale)) continue;
                Locale locale = (Locale)paramValue;
                MybatisI18nContextHolder.setLocaleLanguage(locale.toString());
                selectorMap.put(mapperMethodId, "local");
                return true;
            }
        }
        return Boolean.FALSE;
    }

    public static boolean methodResolver(String mapperMethodId) throws ClassNotFoundException {
        String className = mapperMethodId.substring(0, mapperMethodId.lastIndexOf(46));
        String methodName = mapperMethodId.substring(mapperMethodId.lastIndexOf(46) + 1);
        Class<?> mapperClass = Class.forName(className);
        for (Method method : mapperClass.getMethods()) {
            method.setAccessible(true);
            if (!method.getName().equals(methodName) || !method.isAnnotationPresent(JsonI18nFormatFor.class)) continue;
            selectorMap.put(mapperMethodId, "context");
            return JsonI18nFormatForParamResolver.executeThreadLanguage();
        }
        return Boolean.FALSE;
    }

    public static boolean executeThreadLanguage() {
        Locale locale = (Locale)JaI18nUtil.LocaleThreadLocal.get();
        if (locale != null) {
            MybatisI18nContextHolder.setLocaleLanguage(locale.toString());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void clear() throws ClassNotFoundException {
        JaI18nUtil.LocaleThreadLocal.remove();
    }
}

