/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mybatisi18n;

import com.digiwin.athena.framework.mybatisi18n.MybatisI18nContextHolder;
import com.digiwin.athena.framework.mybatisi18n.utils.I18nUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={String.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class JsonLocaleTypeHandler
extends BaseTypeHandler<String> {
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter);
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.extractLocalizedValue(rs.getString(columnName));
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.extractLocalizedValue(rs.getString(columnIndex));
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.extractLocalizedValue(cs.getString(columnIndex));
    }

    private String extractLocalizedValue(String json) {
        String language = MybatisI18nContextHolder.getLocaleLanguage();
        if (language == null) {
            return json;
        }
        if (!I18nUtils.isValidJson(json)) {
            return json;
        }
        String i18nValue = I18nUtils.extractLocalizedValue(json, language);
        if (StringUtils.isBlank((CharSequence)i18nValue)) {
            return json;
        }
        return i18nValue;
    }
}

