package com.digiwin.athena.framework.mybatisi18n;

import com.digiwin.athena.framework.mybatisi18n.utils.I18nUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@MappedTypes(String.class)
@MappedJdbcTypes(JdbcType.VARCHAR)
public class JsonLocaleTypeHandler extends BaseTypeHandler<String> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter);
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return extractLocalizedValue(rs.getString(columnName));
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return extractLocalizedValue(rs.getString(columnIndex));
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return extractLocalizedValue(cs.getString(columnIndex));
    }

    private String extractLocalizedValue(String json) {
        String language = MybatisI18nContextHolder.getLocaleLanguage();
        //不做处理
        if (language == null) {
            return json;
        }
        //不是语言的json格式
        if (!I18nUtils.isValidJson(json)) {
            return json;
        }
        String i18nValue = I18nUtils.extractLocalizedValue(json, language);
        if (StringUtils.isBlank(i18nValue)) {
            return json;
        }
        return i18nValue;
    }
}
