package com.digiwin.athena.framework.mybatisi18n;

import com.jugg.agile.spring.boot.util.JaI18nUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonI18nFormatForParamResolver {

    public static final Map<String, String> selectorMap = new ConcurrentHashMap();

    /**
     * 解析入口
     *
     * @param mapperMethodId
     * @param argObject
     * @throws ClassNotFoundException
     */
    public static void resolver(String mapperMethodId, Object argObject) throws ClassNotFoundException {

        String localeSelector = selectorMap.getOrDefault(mapperMethodId, "");
        //取上下文
        if (localeSelector.equals(JsonI18nFormatConstant.I18N_MYBTAIS_CONTEXT)) {
            //如果明确是上下文，则直接跳过判断，直接执行
            executeThreadLanguage();
        } else if (localeSelector.equals(JsonI18nFormatConstant.I18N_MYBTAIS_LOCAL)) {
            //解析参数
            JsonI18nFormatForParamResolver.paramResolver(mapperMethodId, argObject);
        } else if (localeSelector.equals(JsonI18nFormatConstant.I18N_MYBTAIS_NONE)) {
            //解析函数
            JsonI18nFormatForParamResolver.methodResolver(mapperMethodId);
        } else {
            //优先匹配Locale入参，如果为空，则匹配上下文的Locale
            boolean isMatch = JsonI18nFormatForParamResolver.paramResolver(mapperMethodId, argObject);
            if (!isMatch) {
                //解析函数
                boolean isMatchSecond = JsonI18nFormatForParamResolver.methodResolver(mapperMethodId);
                if (!isMatchSecond) {
                    selectorMap.putIfAbsent(mapperMethodId, JsonI18nFormatConstant.I18N_MYBTAIS_NONE);
                }
            }
        }
    }

    /**
     * 解析参数注解
     *
     * @param mapperMethodId
     * @param argObject
     * @return
     * @throws ClassNotFoundException
     */
    public static boolean paramResolver(String mapperMethodId, Object argObject) throws ClassNotFoundException {
        String className = mapperMethodId.substring(0, mapperMethodId.lastIndexOf('.'));
        String methodName = mapperMethodId.substring(mapperMethodId.lastIndexOf('.') + 1);
        Class<?> mapperClass = Class.forName(className);
        Method method = null;

        // 遍历查找匹配的方法
        for (Method m : mapperClass.getDeclaredMethods()) {
            if (m.getName().equals(methodName)) {
                method = m;
                break;
            }
        }
        if (method == null) {
            return Boolean.FALSE;
        }
        // 获取方法参数注解
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; i++) {
            for (Annotation annotation : paramAnnotations[i]) {
                if (annotation instanceof JsonI18nFormatFor) {
                    if (argObject instanceof Map) {
                        Map<String, Object> paramMap = (Map<String, Object>) argObject;
                        Object paramValue = paramMap.get(method.getParameters()[i].getName());
                        if (paramValue instanceof Locale) {
                            Locale locale = (Locale) paramValue;
                            MybatisI18nContextHolder.setLocaleLanguage(locale.toString());
                            selectorMap.put(mapperMethodId, JsonI18nFormatConstant.I18N_MYBTAIS_LOCAL);
                            return true;
                        }
                    }
                }
            }
        }
        return Boolean.FALSE;
    }

    /**
     * 解析函数注解
     *
     * @param mapperMethodId
     * @return
     */
    public static boolean methodResolver(String mapperMethodId) throws ClassNotFoundException {
        // 格式为：接口全限定名.方法名
        String className = mapperMethodId.substring(0, mapperMethodId.lastIndexOf('.'));
        String methodName = mapperMethodId.substring(mapperMethodId.lastIndexOf('.') + 1);

        Class<?> mapperClass = Class.forName(className);
        for (Method method : mapperClass.getMethods()) {
            method.setAccessible(true);
            if (method.getName().equals(methodName)) {
                // 检查方法是否包含指定的注解
                if (method.isAnnotationPresent(JsonI18nFormatFor.class)) {
                    selectorMap.put(mapperMethodId, JsonI18nFormatConstant.I18N_MYBTAIS_CONTEXT);
                    return executeThreadLanguage();
                }
            }
        }
        return Boolean.FALSE;
    }


    /**
     * 处理上下文国际化语言
     *
     * @return
     */
    public static boolean executeThreadLanguage() {
        Locale locale = JaI18nUtil.LocaleThreadLocal.get();
        if (locale != null) {
            MybatisI18nContextHolder.setLocaleLanguage(locale.toString());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void clear() throws ClassNotFoundException {
        JaI18nUtil.LocaleThreadLocal.remove();
    }

}
