package com.digiwin.athena.framework.mybatisi18n;

import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts({@Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type = Executor.class, method = "queryCursor", args = {MappedStatement.class, Object.class, RowBounds.class})})
public class LocaleParameterInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement) args[0];
        String mapperMethodId = ms.getId();
        Object argObject = args[1];

        //优先匹配Locale入参，如果为空，则匹配上下文的Locale
        JsonI18nFormatForParamResolver.resolver(mapperMethodId, argObject);

        Object result = null;
        try {
            result = invocation.proceed();
        } finally {
            JsonI18nFormatForParamResolver.clear();
        }
        return result;
    }


}
