package com.digiwin.athena.framework.mq.setup;

import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
//@Component("rabbitMqConcurrencyProperties")
@Configuration
@ConditionalOnProperty(prefix = "athena.mq.concurrency", name = "enable", havingValue = "true")
@ConfigurationProperties(prefix = "athena.mq.concurrency")
public class RabbitMqConcurrencyProperties {

    private Map<String, String> concurrencyMap;

    private boolean enable;
    private List<QueueConsumerConfig> queueConsumers;
//    private List<String> queueMonitors;

    @Data
    public static class QueueConsumerConfig {
        private String queue;
        private Integer minConcurrent;
        private Integer maxConcurrent;
        private Integer prefetchCount;
    }

    public void init() {
        if (queueConsumers != null) {
            concurrencyMap = queueConsumers.stream().collect(Collectors.toMap(QueueConsumerConfig::getQueue, q -> q.getMinConcurrent() + "-" + q.getMaxConcurrent()));
        }
    }

    public String getConcurrency(String queueName) {
        init();
        return concurrencyMap.getOrDefault(queueName, "2-4");
    }
}