package com.digiwin.athena.framework.mq.setup;

import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(RabbitMqConcurrencyProperties.class)
@ConditionalOnProperty(prefix = "athena.mq.concurrency", name = "enable", havingValue = "true")
public class AthenaMQSetUpAutoConfiguration {

    @Bean
    public RabbitMqSetUpConfigUpdater rabbitMqConfigUpdater(RabbitListenerEndpointRegistry registry, ListenerContainerConfigurer listenerContainerConfigurer) {
        return new RabbitMqSetUpConfigUpdater(registry, listenerContainerConfigurer);
    }

    @Bean
    public ListenerContainerConfigurer listenerContainerConfigurer() {
        return new ListenerContainerConfigurer();
    }

}
