/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.setup;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="athena.mq.concurrency", name={"enable"}, havingValue="true")
@ConfigurationProperties(prefix="athena.mq.concurrency")
public class RabbitMqConcurrencyProperties {
    private Map<String, String> concurrencyMap;
    private boolean enable;
    private List<QueueConsumerConfig> queueConsumers;

    public void init() {
        if (this.queueConsumers != null) {
            this.concurrencyMap = this.queueConsumers.stream().collect(Collectors.toMap(QueueConsumerConfig::getQueue, q -> q.getMinConcurrent() + "-" + q.getMaxConcurrent()));
        }
    }

    public String getConcurrency(String queueName) {
        this.init();
        return this.concurrencyMap.getOrDefault(queueName, "2-4");
    }

    public Map<String, String> getConcurrencyMap() {
        return this.concurrencyMap;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public List<QueueConsumerConfig> getQueueConsumers() {
        return this.queueConsumers;
    }

    public void setConcurrencyMap(Map<String, String> concurrencyMap) {
        this.concurrencyMap = concurrencyMap;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setQueueConsumers(List<QueueConsumerConfig> queueConsumers) {
        this.queueConsumers = queueConsumers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMqConcurrencyProperties)) {
            return false;
        }
        RabbitMqConcurrencyProperties other = (RabbitMqConcurrencyProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        Map<String, String> this$concurrencyMap = this.getConcurrencyMap();
        Map<String, String> other$concurrencyMap = other.getConcurrencyMap();
        if (this$concurrencyMap == null ? other$concurrencyMap != null : !((Object)this$concurrencyMap).equals(other$concurrencyMap)) {
            return false;
        }
        List<QueueConsumerConfig> this$queueConsumers = this.getQueueConsumers();
        List<QueueConsumerConfig> other$queueConsumers = other.getQueueConsumers();
        return !(this$queueConsumers == null ? other$queueConsumers != null : !((Object)this$queueConsumers).equals(other$queueConsumers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitMqConcurrencyProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        Map<String, String> $concurrencyMap = this.getConcurrencyMap();
        result = result * 59 + ($concurrencyMap == null ? 43 : ((Object)$concurrencyMap).hashCode());
        List<QueueConsumerConfig> $queueConsumers = this.getQueueConsumers();
        result = result * 59 + ($queueConsumers == null ? 43 : ((Object)$queueConsumers).hashCode());
        return result;
    }

    public String toString() {
        return "RabbitMqConcurrencyProperties(concurrencyMap=" + this.getConcurrencyMap() + ", enable=" + this.isEnable() + ", queueConsumers=" + this.getQueueConsumers() + ")";
    }

    public static class QueueConsumerConfig {
        private String queue;
        private Integer minConcurrent;
        private Integer maxConcurrent;
        private Integer prefetchCount;

        public String getQueue() {
            return this.queue;
        }

        public Integer getMinConcurrent() {
            return this.minConcurrent;
        }

        public Integer getMaxConcurrent() {
            return this.maxConcurrent;
        }

        public Integer getPrefetchCount() {
            return this.prefetchCount;
        }

        public void setQueue(String queue) {
            this.queue = queue;
        }

        public void setMinConcurrent(Integer minConcurrent) {
            this.minConcurrent = minConcurrent;
        }

        public void setMaxConcurrent(Integer maxConcurrent) {
            this.maxConcurrent = maxConcurrent;
        }

        public void setPrefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueueConsumerConfig)) {
                return false;
            }
            QueueConsumerConfig other = (QueueConsumerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$minConcurrent = this.getMinConcurrent();
            Integer other$minConcurrent = other.getMinConcurrent();
            if (this$minConcurrent == null ? other$minConcurrent != null : !((Object)this$minConcurrent).equals(other$minConcurrent)) {
                return false;
            }
            Integer this$maxConcurrent = this.getMaxConcurrent();
            Integer other$maxConcurrent = other.getMaxConcurrent();
            if (this$maxConcurrent == null ? other$maxConcurrent != null : !((Object)this$maxConcurrent).equals(other$maxConcurrent)) {
                return false;
            }
            Integer this$prefetchCount = this.getPrefetchCount();
            Integer other$prefetchCount = other.getPrefetchCount();
            if (this$prefetchCount == null ? other$prefetchCount != null : !((Object)this$prefetchCount).equals(other$prefetchCount)) {
                return false;
            }
            String this$queue = this.getQueue();
            String other$queue = other.getQueue();
            return !(this$queue == null ? other$queue != null : !this$queue.equals(other$queue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueueConsumerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $minConcurrent = this.getMinConcurrent();
            result = result * 59 + ($minConcurrent == null ? 43 : ((Object)$minConcurrent).hashCode());
            Integer $maxConcurrent = this.getMaxConcurrent();
            result = result * 59 + ($maxConcurrent == null ? 43 : ((Object)$maxConcurrent).hashCode());
            Integer $prefetchCount = this.getPrefetchCount();
            result = result * 59 + ($prefetchCount == null ? 43 : ((Object)$prefetchCount).hashCode());
            String $queue = this.getQueue();
            result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
            return result;
        }

        public String toString() {
            return "RabbitMqConcurrencyProperties.QueueConsumerConfig(queue=" + this.getQueue() + ", minConcurrent=" + this.getMinConcurrent() + ", maxConcurrent=" + this.getMaxConcurrent() + ", prefetchCount=" + this.getPrefetchCount() + ")";
        }
    }
}

