package com.digiwin.athena.framework.mq.setup;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

@Slf4j
public class ListenerContainerConfigurer {

    public void configureAndRestart(SimpleMessageListenerContainer simpleContainer, RabbitMqConcurrencyProperties.QueueConsumerConfig config) {

//        RabbitMqConcurrencyProperties.QueueConsumerConfig mqConfig = getConsumersNum(simpleContainer);
//        if (mqConfig == null) {
//            return;
//        }
        simpleContainer.setMaxConcurrentConsumers(config.getMaxConcurrent());
        simpleContainer.setConcurrentConsumers(config.getMinConcurrent());
        // 优先动态调整 prefetchCount，不需要重启
        if (config.getPrefetchCount() != null) {
            simpleContainer.setPrefetchCount(config.getPrefetchCount());
        }
    }

    public RabbitMqConcurrencyProperties.QueueConsumerConfig getConsumersNum(SimpleMessageListenerContainer container) {
        try {
            Field concurrentConsumersField = ReflectionUtils.findField(SimpleMessageListenerContainer.class, "concurrentConsumers");
            if (concurrentConsumersField == null) {
                log.error("Field 'concurrentConsumers' not found in SimpleMessageListenerContainer");
                return null;
            }
            ReflectionUtils.makeAccessible(concurrentConsumersField);
            Integer concurrentConsumers = (Integer) ReflectionUtils.getField(concurrentConsumersField, container);

            RabbitMqConcurrencyProperties.QueueConsumerConfig queueConfig = new RabbitMqConcurrencyProperties.QueueConsumerConfig();
            if (concurrentConsumers != null) {
                queueConfig.setMinConcurrent(concurrentConsumers);
            }

            Field maxConcurrentConsumersField = ReflectionUtils.findField(SimpleMessageListenerContainer.class, "maxConcurrentConsumers");
            if (maxConcurrentConsumersField == null) {
                log.error("Field 'maxConcurrentConsumers' not found in SimpleMessageListenerContainer");
                return null;
            }
            ReflectionUtils.makeAccessible(maxConcurrentConsumersField);
            Integer maxConcurrentConsumers = (Integer) ReflectionUtils.getField(maxConcurrentConsumersField, container);
            if (maxConcurrentConsumers != null) {
                queueConfig.setMaxConcurrent(maxConcurrentConsumers);
            }
            return queueConfig;
        } catch (Exception e) {
            log.error("Unable to access concurrentConsumers field ", e);
            return null;
        }
    }
}