/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.setup;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.framework.mq.setup.ListenerContainerConfigurer;
import com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class RabbitMqSetUpConfigUpdater
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqSetUpConfigUpdater.class);
    private final RabbitListenerEndpointRegistry registry;
    private final ListenerContainerConfigurer configurer;

    public RabbitMqSetUpConfigUpdater(RabbitListenerEndpointRegistry registry, ListenerContainerConfigurer configurer) {
        this.registry = registry;
        this.configurer = configurer;
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            List<RabbitMqConcurrencyProperties.QueueConsumerConfig> queues;
            RabbitMqConcurrencyProperties tempProperties = (RabbitMqConcurrencyProperties)JaSpringBeanUtil.getBean(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties oldProperties = (RabbitMqConcurrencyProperties)JSON.parseObject((String)JSON.toJSONString((Object)tempProperties), RabbitMqConcurrencyProperties.class);
            JaSpringPropertyProcessor.refresh(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties newProperties = (RabbitMqConcurrencyProperties)JaSpringBeanUtil.getBean(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties afterProperties = RabbitMqSetUpConfigUpdater.diffProperties(oldProperties, newProperties);
            log.warn("ccp nacosUpdate:{}" + JSON.toJSONString((Object)afterProperties));
            if (afterProperties != null && !CollectionUtils.isEmpty(queues = afterProperties.getQueueConsumers())) {
                queues.forEach(queueConfig -> {
                    Collection listenerContainers = this.registry.getListenerContainers();
                    if (!CollectionUtils.isEmpty((Collection)listenerContainers)) {
                        listenerContainers.stream().forEach(container -> {
                            SimpleMessageListenerContainer simpleMessageListenerContainer;
                            String[] queueNameArray;
                            if (container instanceof SimpleMessageListenerContainer && (queueNameArray = (simpleMessageListenerContainer = (SimpleMessageListenerContainer)container).getQueueNames()) != null) {
                                Arrays.stream(queueNameArray).forEach(queueName -> {
                                    if (queueConfig.getQueue().equals(queueName)) {
                                        this.configurer.configureAndRestart(simpleMessageListenerContainer, (RabbitMqConcurrencyProperties.QueueConsumerConfig)queueConfig);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.nacosUpdate();
    }

    public static RabbitMqConcurrencyProperties diffProperties(RabbitMqConcurrencyProperties obj1, RabbitMqConcurrencyProperties obj2) {
        RabbitMqConcurrencyProperties result = new RabbitMqConcurrencyProperties();
        if (obj1.getQueueConsumers() != null && obj2.getQueueConsumers() != null) {
            Map<String, RabbitMqConcurrencyProperties.QueueConsumerConfig> map1 = obj1.getQueueConsumers().stream().collect(Collectors.toMap(RabbitMqConcurrencyProperties.QueueConsumerConfig::getQueue, q -> q));
            Map<String, RabbitMqConcurrencyProperties.QueueConsumerConfig> map2 = obj2.getQueueConsumers().stream().collect(Collectors.toMap(RabbitMqConcurrencyProperties.QueueConsumerConfig::getQueue, q -> q));
            ArrayList<RabbitMqConcurrencyProperties.QueueConsumerConfig> diffList = new ArrayList<RabbitMqConcurrencyProperties.QueueConsumerConfig>();
            for (String queue : map2.keySet()) {
                RabbitMqConcurrencyProperties.QueueConsumerConfig q1 = map1.get(queue);
                RabbitMqConcurrencyProperties.QueueConsumerConfig q2 = map2.get(queue);
                if (q1 == null) {
                    diffList.add(q2);
                    continue;
                }
                RabbitMqConcurrencyProperties.QueueConsumerConfig diffConfig = new RabbitMqConcurrencyProperties.QueueConsumerConfig();
                diffConfig.setQueue(queue);
                if (!Objects.equals(q1.getMinConcurrent(), q2.getMinConcurrent())) {
                    diffConfig.setMinConcurrent(q2.getMinConcurrent());
                }
                if (!Objects.equals(q1.getMaxConcurrent(), q2.getMaxConcurrent())) {
                    diffConfig.setMaxConcurrent(q2.getMaxConcurrent());
                }
                if (!Objects.equals(q1.getPrefetchCount(), q2.getPrefetchCount())) {
                    diffConfig.setPrefetchCount(q2.getPrefetchCount());
                }
                if (diffConfig.getMinConcurrent() == null && diffConfig.getMaxConcurrent() == null && diffConfig.getPrefetchCount() == null) continue;
                diffConfig.setMaxConcurrent(q2.getMaxConcurrent());
                diffConfig.setMinConcurrent(q2.getMinConcurrent());
                diffList.add(diffConfig);
            }
            if (!diffList.isEmpty()) {
                result.setQueueConsumers(diffList);
            }
        }
        return result;
    }
}

