/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.setup;

import com.digiwin.athena.framework.mq.setup.RabbitMqConcurrencyProperties;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.util.ReflectionUtils;

public class ListenerContainerConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerConfigurer.class);

    public void configureAndRestart(SimpleMessageListenerContainer simpleContainer, RabbitMqConcurrencyProperties.QueueConsumerConfig config) {
        simpleContainer.setMaxConcurrentConsumers(config.getMaxConcurrent().intValue());
        simpleContainer.setConcurrentConsumers(config.getMinConcurrent().intValue());
        if (config.getPrefetchCount() != null) {
            simpleContainer.setPrefetchCount(config.getPrefetchCount().intValue());
        }
    }

    public RabbitMqConcurrencyProperties.QueueConsumerConfig getConsumersNum(SimpleMessageListenerContainer container) {
        try {
            Field maxConcurrentConsumersField;
            Field concurrentConsumersField = ReflectionUtils.findField(SimpleMessageListenerContainer.class, (String)"concurrentConsumers");
            if (concurrentConsumersField == null) {
                log.error("Field 'concurrentConsumers' not found in SimpleMessageListenerContainer");
                return null;
            }
            ReflectionUtils.makeAccessible((Field)concurrentConsumersField);
            Integer concurrentConsumers = (Integer)ReflectionUtils.getField((Field)concurrentConsumersField, (Object)container);
            RabbitMqConcurrencyProperties.QueueConsumerConfig queueConfig = new RabbitMqConcurrencyProperties.QueueConsumerConfig();
            if (concurrentConsumers != null) {
                queueConfig.setMinConcurrent(concurrentConsumers);
            }
            if ((maxConcurrentConsumersField = ReflectionUtils.findField(SimpleMessageListenerContainer.class, (String)"maxConcurrentConsumers")) == null) {
                log.error("Field 'maxConcurrentConsumers' not found in SimpleMessageListenerContainer");
                return null;
            }
            ReflectionUtils.makeAccessible((Field)maxConcurrentConsumersField);
            Integer maxConcurrentConsumers = (Integer)ReflectionUtils.getField((Field)maxConcurrentConsumersField, (Object)container);
            if (maxConcurrentConsumers != null) {
                queueConfig.setMaxConcurrent(maxConcurrentConsumers);
            }
            return queueConfig;
        }
        catch (Exception e) {
            log.error("Unable to access concurrentConsumers field ", (Throwable)e);
            return null;
        }
    }
}

