package com.digiwin.athena.framework.mq.setup;

import com.alibaba.fastjson.JSON;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
public class RabbitMqSetUpConfigUpdater implements InitializingBean {

    private final RabbitListenerEndpointRegistry registry;
    private final ListenerContainerConfigurer configurer;

    public RabbitMqSetUpConfigUpdater(RabbitListenerEndpointRegistry registry, ListenerContainerConfigurer configurer) {
        this.registry = registry;
        this.configurer = configurer;
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            RabbitMqConcurrencyProperties tempProperties = JaSpringBeanUtil.getBean(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties oldProperties = JSON.parseObject(JSON.toJSONString(tempProperties), RabbitMqConcurrencyProperties.class);
            JaSpringPropertyProcessor.refresh(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties newProperties = JaSpringBeanUtil.getBean(RabbitMqConcurrencyProperties.class);
            RabbitMqConcurrencyProperties afterProperties = diffProperties(oldProperties, newProperties);
            log.warn("ccp nacosUpdate:{}" + JSON.toJSONString(afterProperties));

            if (afterProperties != null) {
                List<RabbitMqConcurrencyProperties.QueueConsumerConfig> queues = afterProperties.getQueueConsumers();
                if (!CollectionUtils.isEmpty(queues)) {
                    queues.forEach(queueConfig -> {
                        Collection<MessageListenerContainer> listenerContainers = registry.getListenerContainers();
                        if (!CollectionUtils.isEmpty(listenerContainers)) {
                            listenerContainers.stream().forEach(container -> {
                                if (container instanceof SimpleMessageListenerContainer) {
                                    SimpleMessageListenerContainer simpleMessageListenerContainer = (SimpleMessageListenerContainer) container;
                                    String[] queueNameArray = simpleMessageListenerContainer.getQueueNames();
                                    if (queueNameArray != null) {
                                        Arrays.stream(queueNameArray).forEach(queueName -> {
                                            if (queueConfig.getQueue().equals(queueName)) {
                                                configurer.configureAndRestart(simpleMessageListenerContainer, queueConfig);
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        nacosUpdate();
    }

    public static RabbitMqConcurrencyProperties diffProperties(RabbitMqConcurrencyProperties obj1, RabbitMqConcurrencyProperties obj2) {
        RabbitMqConcurrencyProperties result = new RabbitMqConcurrencyProperties();
//        if (!Objects.equals(obj1.getQueueMonitors(), obj2.getQueueMonitors())) {
//            result.setQueueMonitors(obj2.getQueueMonitors());
//        }
        if (obj1.getQueueConsumers() != null && obj2.getQueueConsumers() != null) {
            Map<String, RabbitMqConcurrencyProperties.QueueConsumerConfig> map1 = obj1.getQueueConsumers().stream().collect(Collectors.toMap(RabbitMqConcurrencyProperties.QueueConsumerConfig::getQueue, q -> q));
            Map<String, RabbitMqConcurrencyProperties.QueueConsumerConfig> map2 = obj2.getQueueConsumers().stream().collect(Collectors.toMap(RabbitMqConcurrencyProperties.QueueConsumerConfig::getQueue, q -> q));
            List<RabbitMqConcurrencyProperties.QueueConsumerConfig> diffList = new ArrayList<>();

            for (String queue : map2.keySet()) {
                RabbitMqConcurrencyProperties.QueueConsumerConfig q1 = map1.get(queue);
                RabbitMqConcurrencyProperties.QueueConsumerConfig q2 = map2.get(queue);

                if (q1 == null) {
                    // 直接新增
                    diffList.add(q2);
                } else {
                    // 逐个比较字段
                    RabbitMqConcurrencyProperties.QueueConsumerConfig diffConfig = new RabbitMqConcurrencyProperties.QueueConsumerConfig();
                    diffConfig.setQueue(queue);

                    if (!Objects.equals(q1.getMinConcurrent(), q2.getMinConcurrent())) {
                        diffConfig.setMinConcurrent(q2.getMinConcurrent());
                    }
                    if (!Objects.equals(q1.getMaxConcurrent(), q2.getMaxConcurrent())) {
                        diffConfig.setMaxConcurrent(q2.getMaxConcurrent());
                    }
                    if (!Objects.equals(q1.getPrefetchCount(), q2.getPrefetchCount())) {
                        diffConfig.setPrefetchCount(q2.getPrefetchCount());
                    }

                    // 只有有差异的才加入
                    if (diffConfig.getMinConcurrent() != null || diffConfig.getMaxConcurrent() != null || diffConfig.getPrefetchCount() != null) {
                        diffConfig.setMaxConcurrent(q2.getMaxConcurrent());
                        diffConfig.setMinConcurrent(q2.getMinConcurrent());
//                        diffConfig.setPrefetchCount(q2.getPrefetchCount());
                        diffList.add(diffConfig);
                    }
                }
            }

            if (!diffList.isEmpty()) {
                result.setQueueConsumers(diffList);
            }
        }

        return result;
    }
}