package com.digiwin.athena.framework.mq.retry.annotation;

import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListeners;
import org.springframework.messaging.handler.annotation.MessageMapping;

import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RabbitRetry {

    //初始间隔为1秒
    long initialInterval = 1000L;

    //每次重试间隔倍增
    double multiplier = 2;

    // 最大间隔为10秒
    long maxInterval = 10000;

    //最大重试次数
    int maxAttempts() default 3;

    // 初始化方法
    String initHandler() default "";

    // 幂等
    String idempotentHandler() default "";

    // 成功方法
    String successHander() default "";

    // 失败方法
    String failureHandler() default "";

    // 需要重试的异常
    Class<? extends Throwable>[] retryForExceptions() default {};

    // 快速失败的异常
    Class<? extends Throwable>[] rejectForException() default {};

    // 需要直接返回队列的异常
    Class<? extends Throwable>[] loopForExceptions() default {};
}
