package com.digiwin.athena.framework.mq.retry;

import com.digiwin.athena.framework.mq.retry.interceptor.RabbitRetryInterceptor;
import com.digiwin.athena.framework.mq.retry.support.RabbitRetryAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(RabbitMqRetryProperties.class)
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
public class AthenaMQRetryAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public RabbitMqRetryConfigUpdater rabbitMqMonitorConfigUpdater(RabbitMqRetryProperties retryProperties) {
        return new RabbitMqRetryConfigUpdater(retryProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitRetryInterceptor rabbitRetryInterceptor(RabbitTemplate rabbitTemplate, RabbitMqRetryProperties retryProperties) {
        return new RabbitRetryInterceptor(rabbitTemplate, retryProperties);
    }

    @Bean
    public RabbitRetryAnnotationBeanPostProcessor rabbitRetryAnnotationBeanPostProcessor() {
        RabbitRetryAnnotationBeanPostProcessor processor = new RabbitRetryAnnotationBeanPostProcessor();
        return processor;
    }

}
