package com.digiwin.athena.framework.mq.retry.annotation;

import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.exception.RetryMQException;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListeners;
import org.springframework.messaging.handler.annotation.MessageMapping;

import java.lang.annotation.*;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RabbitRetry {

    //初始间隔为1秒
    long initialInterval = 1000L;

    //每次重试间隔倍增
    double multiplier = 2;

    // 最大间隔为10秒
    long maxInterval = 10000;

    //最大重试次数
    int maxAttempts() default 3;

    // 幂等+初始化
    String beforeHandler();

    // 成功方法
    String successHander();

    // 失败方法
    String failureHandler();

    // 快速失败的异常
    Class<? extends Throwable>[] rejectForException() default RejectMQException.class;

    // 需要直接返回队列的异常
    Class<? extends Throwable>[] retryForMQExceptions() default RetryMQException.class;
}
