package com.digiwin.athena.framework.mq.retry.support;

import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.digiwin.athena.framework.mq.retry.handler.HandlerAdapter;
import lombok.Data;

import java.lang.reflect.Method;


@Data
public class RabbitRetryMethod {

    final Method method;

    final RabbitRetry annotation;

    HandlerAdapter handlerAdapter;

    RabbitRetryMethod(Method method, RabbitRetry annotation) {
        this.method = method;
        this.annotation = annotation;
    }

    public HandlerAdapter getHandlerAdapter() {
        return handlerAdapter;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }
}
