package com.digiwin.athena.framework.mq.retry;

import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import org.springframework.beans.factory.InitializingBean;

public class RabbitMqRetryConfigUpdater implements InitializingBean {

    private  RabbitMqRetryProperties configurer;

    public RabbitMqRetryConfigUpdater(RabbitMqRetryProperties configurer) {
        this.configurer = configurer;
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            JaSpringPropertyProcessor.refresh(RabbitMqRetryProperties.class);
        });
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        nacosUpdate();
    }

}
