package com.digiwin.athena.framework.mq.retry.support;

import com.digiwin.athena.framework.mq.retry.RabbitMqRetryProperties;
import com.jugg.agile.framework.core.util.concurrent.JaExecutors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultExecutorServiceProvider implements ExecutorServiceProvider {

    @Override
    public ExecutorService provide(RabbitMqRetryProperties properties) {
        RabbitMqRetryProperties.ThreadPoolConfig config = properties.getPoolConfig();
        return JaExecutors.createExecutorService(JaExecutors.Config.builder().prefixYaml("RabbitRetryExecutor").defaultPrefixName("RabbitRetryExecutor").defaultCorePoolSize(config.getCoreSize()).defaultMaximumPoolSize(config.getMaxSize()).defaultKeepAliveTime(config.getKeepAliveTime()).defaultQueueSize(config.getQueueSize()).handler(new ThreadPoolExecutor.CallerRunsPolicy()).build());
    }
}
