/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.retry.interceptor;

import com.digiwin.athena.framework.mq.retry.RabbitMqRetryProperties;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.exception.OverLimitException;
import com.digiwin.athena.framework.mq.retry.exception.RejectMQException;
import com.digiwin.athena.framework.mq.retry.exception.RetryMQException;
import com.digiwin.athena.framework.mq.retry.interceptor.AbstractInterceptor;
import com.digiwin.athena.framework.mq.retry.support.ExecutorServiceProvider;
import com.digiwin.athena.framework.mq.retry.support.RabbitMqHandlerMethodArgumentResolver;
import com.digiwin.athena.framework.mq.retry.support.RabbitRetryMethod;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.StringUtils;

@Aspect
@ConditionalOnProperty(prefix="athena.mq.retry", name={"enable"}, havingValue="true")
public class RabbitRetryInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RabbitRetryInterceptor.class);

    public RabbitRetryInterceptor(RabbitTemplate rabbitTemplate, RabbitMqRetryProperties retryProperties, @Nullable ExecutorServiceProvider provider) {
        super(rabbitTemplate, retryProperties, provider);
    }

    @Override
    protected Object processMessage(ProceedingJoinPoint joinPoint, RabbitRetryMethod retryMethod, RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding, RabbitRetry rabbitRetry) throws Throwable {
        try {
            Object result = joinPoint.proceed();
            this.executeSuccessHandler(retryMethod);
            return result;
        }
        catch (Throwable e) {
            this.handleProcessingException(e, queueBinding, rabbitRetry, joinPoint, retryMethod);
            return null;
        }
    }

    @Override
    protected void validateQueueBinding(RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding) {
        if (StringUtils.isEmpty((Object)queueBinding.getExchangeName()) || StringUtils.isEmpty((Object)queueBinding.getRoutingkey())) {
            throw new RejectMQException("RabbitRetryInterceptor Exchange or Routing Key not found");
        }
    }

    @Override
    protected void validateRetryCount(RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding) {
        Integer retryCount = Optional.ofNullable(queueBinding.getRetryCount()).orElse(0);
        if ((long)retryCount.intValue() >= this.retryProperties.getMaxMQRetryCount()) {
            throw new OverLimitException("RabbitRetryInterceptor Retry count exceeds maximum limit");
        }
    }

    private void handleProcessingException(Throwable e, RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding, RabbitRetry rabbitRetry, ProceedingJoinPoint joinPoint, RabbitRetryMethod retryMethod) throws Throwable {
        Class<? extends Throwable>[] rejectClasses = rabbitRetry.rejectForException();
        Class<? extends Throwable>[] retryClasses = rabbitRetry.retryForMQExceptions();
        if (e instanceof RejectMQException || this.isExceptionInList(e, rejectClasses)) {
            this.executeFailureMethod(retryMethod, e);
            return;
        }
        if (e instanceof RetryMQException || this.isExceptionInList(e, retryClasses)) {
            this.executeFailureMethod(retryMethod, e);
            this.retryWithBackToQueue(queueBinding);
            return;
        }
        this.handleRetry(joinPoint, retryMethod, rabbitRetry, queueBinding);
    }

    private void retryWithBackToQueue(RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBindingBean) {
        this.rabbitTemplate.convertAndSend(queueBindingBean.getExchangeName(), queueBindingBean.getRoutingkey(), queueBindingBean.getMessage(), message -> {
            MessageProperties messageProperties = message.getMessageProperties();
            int retryCount = Optional.ofNullable(queueBindingBean.getRetryCount()).orElse(0);
            messageProperties.setHeader("retry-count", (Object)(retryCount + 1));
            return message;
        });
    }

    private void handleRetry(ProceedingJoinPoint joinPoint, RabbitRetryMethod retryMethod, RabbitRetry rabbitRetry, RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBindingBean) throws Throwable {
        RetryTemplate retryTemplate = this.createRetryTemplate(rabbitRetry);
        retryTemplate.execute(context -> {
            Object result = joinPoint.proceed();
            MQRetryContextHolder.getContext().setLocalRetrycount(context.getRetryCount() + 1);
            this.executeSuccessHandler(retryMethod);
            return result;
        }, context -> {
            MQRetryContextHolder.getContext().setLocalRetrycount(context.getRetryCount() + 1);
            this.executeFailureMethod(retryMethod, context.getLastThrowable());
            return null;
        });
    }

    private boolean isExceptionInList(Throwable e, Class<? extends Throwable>[] throwableClasses) {
        for (Class<? extends Throwable> clazz : throwableClasses) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }
}

