/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.retry.support;

import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.digiwin.athena.framework.mq.retry.handler.BeforeHandler;
import com.digiwin.athena.framework.mq.retry.handler.FailureHandler;
import com.digiwin.athena.framework.mq.retry.handler.HandlerAdapter;
import com.digiwin.athena.framework.mq.retry.handler.SuccessHandler;
import com.digiwin.athena.framework.mq.retry.support.RabbitRetryMethod;
import com.digiwin.athena.framework.mq.retry.support.RetrySingleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RabbitRetryAnnotationBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(RabbitRetryAnnotationBeanPostProcessor.class);
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        this.buildRabbitRetryMethod(targetClass);
        return bean;
    }

    private void buildRabbitRetryMethod(Class<?> targetClass) {
        ReflectionUtils.doWithMethods(targetClass, method -> {
            RabbitRetry retryAnnotation = this.findRabbitRetryAnnotations(method);
            if (retryAnnotation != null) {
                RabbitListener rabbitListener = this.findRabbitListerAnnotations(method);
                if (rabbitListener == null) {
                    throw new IllegalArgumentException("RabbitRetry annotation must be used with RabbitListener annotation, but found on method " + method.getName() + " in class " + targetClass.getName());
                }
                RabbitRetryMethod retryMethod = new RabbitRetryMethod(method, retryAnnotation);
                HandlerAdapter handlerAdapter = new HandlerAdapter();
                this.extracted(targetClass, method, retryAnnotation, handlerAdapter, retryMethod);
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
    }

    private void extracted(Class<?> targetClass, Method method, RabbitRetry retryAnnotation, HandlerAdapter handlerAdapter, RabbitRetryMethod retryMethod) {
        String failureHandlerName;
        String successHanderBeanName;
        String beforeHandlerBeanName = retryAnnotation.beforeHandler();
        if (!StringUtils.isEmpty((Object)beforeHandlerBeanName)) {
            BeforeHandler beforeHandler = (BeforeHandler)this.beanFactory.getBean(beforeHandlerBeanName);
            if (beforeHandler == null) {
                throw new NoSuchBeanDefinitionException(targetClass.getName() + "RabbitRetry beforeHandler not found");
            }
            handlerAdapter.setBeforeHandler(beforeHandler);
        }
        if (!StringUtils.isEmpty((Object)(successHanderBeanName = retryAnnotation.successHander()))) {
            SuccessHandler successHandler = (SuccessHandler)this.beanFactory.getBean(successHanderBeanName);
            if (successHandler == null) {
                throw new NoSuchBeanDefinitionException(targetClass.getName() + "RabbitRetry successHandler not found");
            }
            handlerAdapter.setSuccessHandler(successHandler);
        }
        if (!StringUtils.isEmpty((Object)(failureHandlerName = retryAnnotation.failureHandler()))) {
            FailureHandler failureHandler = (FailureHandler)this.beanFactory.getBean(failureHandlerName);
            if (failureHandler == null) {
                throw new NoSuchBeanDefinitionException(targetClass.getName() + "RabbitRetry failureHandler not found");
            }
            handlerAdapter.setFailureHandler(failureHandler);
        }
        retryMethod.setHandlerAdapter(handlerAdapter);
        RetrySingleton.getInstance().put(method, retryMethod);
    }

    private RabbitRetry findRabbitRetryAnnotations(Method element) {
        if (element.getDeclaringClass() != Object.class) {
            RabbitRetry retryAnnotation = element.getAnnotation(RabbitRetry.class);
            return retryAnnotation;
        }
        return null;
    }

    private RabbitListener findRabbitListerAnnotations(Method element) {
        if (element.getDeclaringClass() != Object.class) {
            RabbitListener rabbitListener = element.getAnnotation(RabbitListener.class);
            return rabbitListener;
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private void validateRabbitListenerParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        boolean hasDeliveryTag = false;
        boolean hasRetryCount = false;
        for (Parameter parameter : parameters) {
            Annotation headerAnnotation = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, Header.class);
            if (headerAnnotation == null) continue;
            String headerName = ((Header)headerAnnotation).value();
            if ("amqp_deliveryTag".equals(headerName)) {
                hasDeliveryTag = true;
            }
            if (!"retry-count".equals(headerName)) continue;
            hasRetryCount = true;
        }
        if (!hasDeliveryTag) {
            throw new IllegalArgumentException("@RabbitListener method " + method.getName() + " in class " + method.getDeclaringClass().getName() + " must include parameter annotated with @Header(AmqpHeaders.DELIVERY_TAG).");
        }
        if (!hasRetryCount) {
            throw new IllegalArgumentException("@RabbitListener method " + method.getName() + " in class " + method.getDeclaringClass().getName() + " must include parameter annotated with @Header(\"retry-count\").");
        }
    }
}

