/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.retry;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="athena.mq.retry", name={"enable"}, havingValue="true")
@ConfigurationProperties(prefix="athena.mq.retry")
public class RabbitMqRetryProperties {
    private boolean enable;
    private boolean async;
    private long asyncTimeout = 3000L;
    private long maxMQRetryCount = 3L;
    private ThreadPoolConfig poolConfig;

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isAsync() {
        return this.async;
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public long getMaxMQRetryCount() {
        return this.maxMQRetryCount;
    }

    public ThreadPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    public void setMaxMQRetryCount(long maxMQRetryCount) {
        this.maxMQRetryCount = maxMQRetryCount;
    }

    public void setPoolConfig(ThreadPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMqRetryProperties)) {
            return false;
        }
        RabbitMqRetryProperties other = (RabbitMqRetryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.getAsyncTimeout() != other.getAsyncTimeout()) {
            return false;
        }
        if (this.getMaxMQRetryCount() != other.getMaxMQRetryCount()) {
            return false;
        }
        ThreadPoolConfig this$poolConfig = this.getPoolConfig();
        ThreadPoolConfig other$poolConfig = other.getPoolConfig();
        return !(this$poolConfig == null ? other$poolConfig != null : !((Object)this$poolConfig).equals(other$poolConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitMqRetryProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isAsync() ? 79 : 97);
        long $asyncTimeout = this.getAsyncTimeout();
        result = result * 59 + (int)($asyncTimeout >>> 32 ^ $asyncTimeout);
        long $maxMQRetryCount = this.getMaxMQRetryCount();
        result = result * 59 + (int)($maxMQRetryCount >>> 32 ^ $maxMQRetryCount);
        ThreadPoolConfig $poolConfig = this.getPoolConfig();
        result = result * 59 + ($poolConfig == null ? 43 : ((Object)$poolConfig).hashCode());
        return result;
    }

    public String toString() {
        return "RabbitMqRetryProperties(enable=" + this.isEnable() + ", async=" + this.isAsync() + ", asyncTimeout=" + this.getAsyncTimeout() + ", maxMQRetryCount=" + this.getMaxMQRetryCount() + ", poolConfig=" + this.getPoolConfig() + ")";
    }

    public static class ThreadPoolConfig {
        private Integer coreSize = 10;
        private Integer maxSize = 50;
        private Long keepAliveTime = 60L;
        private Integer queueSize = 2000;
        private Long timeOut = 60000L;

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Integer getQueueSize() {
            return this.queueSize;
        }

        public Long getTimeOut() {
            return this.timeOut;
        }

        public void setCoreSize(Integer coreSize) {
            this.coreSize = coreSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public void setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setQueueSize(Integer queueSize) {
            this.queueSize = queueSize;
        }

        public void setTimeOut(Long timeOut) {
            this.timeOut = timeOut;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadPoolConfig)) {
                return false;
            }
            ThreadPoolConfig other = (ThreadPoolConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$coreSize = this.getCoreSize();
            Integer other$coreSize = other.getCoreSize();
            if (this$coreSize == null ? other$coreSize != null : !((Object)this$coreSize).equals(other$coreSize)) {
                return false;
            }
            Integer this$maxSize = this.getMaxSize();
            Integer other$maxSize = other.getMaxSize();
            if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
                return false;
            }
            Long this$keepAliveTime = this.getKeepAliveTime();
            Long other$keepAliveTime = other.getKeepAliveTime();
            if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
                return false;
            }
            Integer this$queueSize = this.getQueueSize();
            Integer other$queueSize = other.getQueueSize();
            if (this$queueSize == null ? other$queueSize != null : !((Object)this$queueSize).equals(other$queueSize)) {
                return false;
            }
            Long this$timeOut = this.getTimeOut();
            Long other$timeOut = other.getTimeOut();
            return !(this$timeOut == null ? other$timeOut != null : !((Object)this$timeOut).equals(other$timeOut));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadPoolConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $coreSize = this.getCoreSize();
            result = result * 59 + ($coreSize == null ? 43 : ((Object)$coreSize).hashCode());
            Integer $maxSize = this.getMaxSize();
            result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
            Long $keepAliveTime = this.getKeepAliveTime();
            result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
            Integer $queueSize = this.getQueueSize();
            result = result * 59 + ($queueSize == null ? 43 : ((Object)$queueSize).hashCode());
            Long $timeOut = this.getTimeOut();
            result = result * 59 + ($timeOut == null ? 43 : ((Object)$timeOut).hashCode());
            return result;
        }

        public String toString() {
            return "RabbitMqRetryProperties.ThreadPoolConfig(coreSize=" + this.getCoreSize() + ", maxSize=" + this.getMaxSize() + ", keepAliveTime=" + this.getKeepAliveTime() + ", queueSize=" + this.getQueueSize() + ", timeOut=" + this.getTimeOut() + ")";
        }
    }
}

