/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.retry.interceptor;

import com.digiwin.athena.framework.mq.retry.RabbitMqRetryProperties;
import com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry;
import com.digiwin.athena.framework.mq.retry.context.MQRetryContextHolder;
import com.digiwin.athena.framework.mq.retry.handler.FailureHandler;
import com.digiwin.athena.framework.mq.retry.support.ExecutorServiceProvider;
import com.digiwin.athena.framework.mq.retry.support.RabbitMqHandlerMethodArgumentResolver;
import com.digiwin.athena.framework.mq.retry.support.RabbitRetryMethod;
import com.digiwin.athena.framework.mq.retry.support.RetrySingleton;
import com.jugg.agile.framework.core.util.concurrent.JaExecutors;
import com.jugg.agile.middleware.rabbitmq.spring.JaNodeSpanRabbitListenerConsumer;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public abstract class AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractInterceptor.class);
    protected final RabbitTemplate rabbitTemplate;
    protected final RabbitMqRetryProperties retryProperties;
    private final ExecutorService threadPoolTaskExecutor;

    protected AbstractInterceptor(RabbitTemplate rabbitTemplate, RabbitMqRetryProperties retryProperties, @Nullable ExecutorServiceProvider provider) {
        this.rabbitTemplate = rabbitTemplate;
        this.retryProperties = retryProperties;
        this.threadPoolTaskExecutor = provider.provide(retryProperties);
    }

    private ExecutorService createThreadPool(RabbitMqRetryProperties rabbitMqRetryProperties) {
        RabbitMqRetryProperties.ThreadPoolConfig config = rabbitMqRetryProperties.getPoolConfig();
        return JaExecutors.createExecutorService((JaExecutors.Config)JaExecutors.Config.builder().prefixYaml("RabbitRetryExecutor").defaultPrefixName("RabbitRetryExecutor").defaultCorePoolSize(config.getCoreSize()).defaultMaximumPoolSize(config.getMaxSize()).defaultKeepAliveTime(config.getKeepAliveTime()).defaultQueueSize(config.getQueueSize()).handler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy()).build());
    }

    @Pointcut(value="@annotation(com.digiwin.athena.framework.mq.retry.annotation.RabbitRetry)")
    public void rabbitListenerMethods() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="rabbitListenerMethods()")
    public Object intercept(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        RabbitRetry rabbitRetry = method.getAnnotation(RabbitRetry.class);
        RabbitListener rabbitListener = method.getAnnotation(RabbitListener.class);
        if (rabbitRetry == null || rabbitListener == null) {
            log.warn("RabbitRetryInterceptor Missing RabbitRetry or RabbitListener annotation on method: {}", (Object)method.getName());
            return joinPoint.proceed();
        }
        log.info("RabbitRetryInterceptor start");
        MQRetryContextHolder.MQRetryContext mqRetryContext = MQRetryContextHolder.getContext();
        Object[] args = joinPoint.getArgs();
        RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding = this.resolveQueueBinding(rabbitListener, method, args, this.rabbitTemplate);
        if (queueBinding == null) {
            log.info("RabbitRetryInterceptor queueBinding is null");
            return null;
        }
        mqRetryContext.setQueueBinding(queueBinding);
        mqRetryContext.setMqRetrycount(queueBinding.getRetryCount());
        Channel channel = (Channel)JaNodeSpanRabbitListenerConsumer.ChannelThreadLocal.get();
        Message message = (Message)JaNodeSpanRabbitListenerConsumer.MessageThreadLocal.get();
        MessageProperties properties = message.getMessageProperties();
        long tag = properties.getDeliveryTag();
        RabbitRetryMethod retryMethod = this.getRetryMethod(method);
        try {
            this.validateQueueBinding(queueBinding);
            this.validateRetryCount(queueBinding);
            this.executeBeforeHandler(retryMethod);
            Future<?> future = this.threadPoolTaskExecutor.submit(() -> {
                try {
                    this.processMessage(joinPoint, retryMethod, queueBinding, rabbitRetry);
                }
                catch (Throwable e) {
                    log.error("RabbitRetryInterceptor Error processing message", e);
                }
                finally {
                    MQRetryContextHolder.clearContext();
                }
            });
            Object var16_16 = this.retryProperties.isAsync() ? null : future.get(this.retryProperties.getAsyncTimeout(), TimeUnit.MILLISECONDS);
            return var16_16;
        }
        catch (Exception e) {
            this.executeFailureMethod(retryMethod, e);
        }
        finally {
            MQRetryContextHolder.clearContext();
            this.acKnowledgeMessage(channel, tag);
        }
        return null;
    }

    protected abstract Object processMessage(ProceedingJoinPoint var1, RabbitRetryMethod var2, RabbitMqHandlerMethodArgumentResolver.QueueBindingBean var3, RabbitRetry var4) throws Throwable;

    protected abstract void validateQueueBinding(RabbitMqHandlerMethodArgumentResolver.QueueBindingBean var1);

    protected abstract void validateRetryCount(RabbitMqHandlerMethodArgumentResolver.QueueBindingBean var1);

    protected RabbitRetryMethod getRetryMethod(Method method) {
        return RetrySingleton.getInstance().get(method);
    }

    protected void executeBeforeHandler(RabbitRetryMethod retryMethod) {
        retryMethod.getHandlerAdapter().getBeforeHandler().invokeHandler();
    }

    protected void executeSuccessHandler(RabbitRetryMethod retryMethod) {
        retryMethod.getHandlerAdapter().getSuccessHandler().invokeHandler();
    }

    protected void executeFailureMethod(RabbitRetryMethod retryMethod, Throwable throwable) {
        MQRetryContextHolder.getContext().setLastException(throwable);
        FailureHandler failureHandler = retryMethod.getHandlerAdapter().getFailureHandler();
        failureHandler.invokeHandler();
    }

    protected Channel resolveChannel(Object[] args) {
        return RabbitMqHandlerMethodArgumentResolver.resolveArgumentChannel(args);
    }

    protected Long resolveTag(Method method, Object[] args) {
        return RabbitMqHandlerMethodArgumentResolver.resolveArgumentTag(method, args);
    }

    protected RabbitMqHandlerMethodArgumentResolver.QueueBindingBean resolveQueueBinding(RabbitListener rabbitListener, Method method, Object[] args, RabbitTemplate rabbitTemplate) {
        return RabbitMqHandlerMethodArgumentResolver.resolveExchangeRoutingkeyMsg(rabbitListener, method, args, rabbitTemplate);
    }

    protected RetryTemplate createRetryTemplate(RabbitRetry rabbitRetry) {
        RetryTemplate template = new RetryTemplate();
        HashMap<Class<Exception>, Boolean> retryableExceptions = new HashMap<Class<Exception>, Boolean>();
        retryableExceptions.put(Exception.class, true);
        Class<? extends Throwable>[] classes = rabbitRetry.rejectForException();
        Arrays.stream(classes).forEach(e -> retryableExceptions.put((Class<Exception>)e, false));
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(rabbitRetry.maxAttempts(), retryableExceptions);
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(1000L);
        backOffPolicy.setMultiplier(2.0);
        backOffPolicy.setMaxInterval(10000L);
        template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return template;
    }

    private void acKnowledgeMessage(Channel channel, Long tag) throws IOException {
        log.info("RabbitRetryInterceptor auto ack start");
        if (channel != null && channel.isOpen() && tag != null) {
            log.info("RabbitRetryInterceptor msg ack");
            try {
                channel.basicAck(tag.longValue(), false);
            }
            catch (Exception e) {
                log.error("RabbitRetryInterceptor msg ack error,tag:{}", (Object)tag, (Object)e);
            }
        } else {
            log.error("RabbitRetryInterceptor cannot found channel or tag");
        }
    }
}

