package com.digiwin.athena.framework.mq.retry;

import com.digiwin.athena.framework.mq.retry.interceptor.RabbitRetryInterceptor;
import com.digiwin.athena.framework.mq.retry.support.DefaultExecutorServiceProvider;
import com.digiwin.athena.framework.mq.retry.support.ExecutorServiceProvider;
import com.digiwin.athena.framework.mq.retry.support.RabbitRetryAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(RabbitMqRetryProperties.class)
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
public class AthenaMQRetryAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public RabbitMqRetryConfigUpdater rabbitMqRetryConfigUpdater(RabbitMqRetryProperties retryProperties) {
        return new RabbitMqRetryConfigUpdater(retryProperties);
    }

    @Order(Ordered.HIGHEST_PRECEDENCE + 1000)
    @Bean
    @ConditionalOnMissingBean
    public RabbitRetryInterceptor rabbitRetryInterceptor(RabbitTemplate rabbitTemplate, RabbitMqRetryProperties retryProperties, ExecutorServiceProvider provider) {
        return new RabbitRetryInterceptor(rabbitTemplate, retryProperties, provider);
    }

    @Bean
    public RabbitRetryAnnotationBeanPostProcessor rabbitRetryAnnotationBeanPostProcessor() {
        RabbitRetryAnnotationBeanPostProcessor processor = new RabbitRetryAnnotationBeanPostProcessor();
        return processor;
    }

    @Bean
    public ExecutorServiceProvider executorServiceProvider(RabbitMqRetryProperties retryProperties) {
        ExecutorServiceProvider executorServiceProvider = new DefaultExecutorServiceProvider();
        return executorServiceProvider;
    }

//    @Bean
//    public RabbitMqRetryProperties rabbitMqRetryProperties() {
//        return new RabbitMqRetryProperties();
//    }

}
