/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mq.retry.support;

import com.jugg.agile.middleware.rabbitmq.spring.JaNodeSpanRabbitListenerConsumer;
import com.rabbitmq.client.Channel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.Header;

public class RabbitMqHandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqHandlerMethodArgumentResolver.class);

    public static Channel resolveArgumentChannel(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof Channel)) continue;
            Channel channel = (Channel)arg;
            return channel;
        }
        return null;
    }

    public static Long resolveArgumentTag(Method method, Object[] args) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                Header header;
                if (!(annotation instanceof Header) || !"amqp_deliveryTag".equals((header = (Header)annotation).value())) continue;
                return (Long)args[i];
            }
        }
        return null;
    }

    public static Integer resolveArgumentRetryCount(Method method, Object[] args) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                Header header;
                if (!(annotation instanceof Header) || !"retry-count".equals((header = (Header)annotation).value())) continue;
                return (Integer)args[i];
            }
        }
        return 0;
    }

    public static QueueBindingBean resolveExchangeRoutingkeyMsg(RabbitListener rabbitListener, Method method, Object[] args, RabbitTemplate rabbitTemplate) {
        QueueBinding[] queueBindings = rabbitListener.bindings();
        QueueBindingBean queueBindingBean = new QueueBindingBean();
        if (queueBindings != null) {
            org.springframework.amqp.core.Message message;
            QueueBinding queueBinding = queueBindings[0];
            Exchange exchange = queueBinding.exchange();
            String exchangeName = exchange.value();
            queueBindingBean.setExchangeName(exchangeName);
            Queue queue = queueBinding.value();
            String queueName = queue.value();
            queueBindingBean.setQueueName(queueName);
            String[] keys = queueBinding.key();
            if (keys != null) {
                String routingkey = keys[0];
                queueBindingBean.setRoutingkey(routingkey);
            }
            if ((message = (org.springframework.amqp.core.Message)JaNodeSpanRabbitListenerConsumer.MessageThreadLocal.get()) == null) {
                log.warn("RabbitRetryInterceptor message is null");
                return null;
            }
            Object msg = rabbitTemplate.getMessageConverter().fromMessage(message);
            queueBindingBean.setMessage(msg);
            MessageProperties properties = message.getMessageProperties();
            Integer retryCount = (Integer)properties.getHeader("retry-count");
            queueBindingBean.setRetryCount(retryCount == null ? 0 : retryCount);
        }
        return queueBindingBean;
    }

    private static boolean isMessageBody(Class<?> paramType, Annotation[] annotations) {
        return !RabbitMqHandlerMethodArgumentResolver.isHeaderParam(annotations) && (paramType == String.class || paramType == byte[].class || paramType.isAssignableFrom(Message.class) || paramType.isAssignableFrom(Object.class));
    }

    private static boolean isHeaderParam(Annotation[] annotations) {
        return Arrays.stream(annotations).anyMatch(ann -> ann.annotationType() == Header.class);
    }

    public static Object getMessage(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            Annotation[] annotations = parameterAnnotations[i];
            if (!RabbitMqHandlerMethodArgumentResolver.isMessageBody(paramType, annotations)) continue;
            Object msg = args[i];
            return msg;
        }
        return null;
    }

    public static class QueueBindingBean {
        private String exchangeName;
        private String queueName;
        private String routingkey;
        private Object message;
        private Integer retryCount = 0;

        public String getExchangeName() {
            return this.exchangeName;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getRoutingkey() {
            return this.routingkey;
        }

        public Object getMessage() {
            return this.message;
        }

        public Integer getRetryCount() {
            return this.retryCount;
        }

        public void setExchangeName(String exchangeName) {
            this.exchangeName = exchangeName;
        }

        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public void setRoutingkey(String routingkey) {
            this.routingkey = routingkey;
        }

        public void setMessage(Object message) {
            this.message = message;
        }

        public void setRetryCount(Integer retryCount) {
            this.retryCount = retryCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueueBindingBean)) {
                return false;
            }
            QueueBindingBean other = (QueueBindingBean)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$retryCount = this.getRetryCount();
            Integer other$retryCount = other.getRetryCount();
            if (this$retryCount == null ? other$retryCount != null : !((Object)this$retryCount).equals(other$retryCount)) {
                return false;
            }
            String this$exchangeName = this.getExchangeName();
            String other$exchangeName = other.getExchangeName();
            if (this$exchangeName == null ? other$exchangeName != null : !this$exchangeName.equals(other$exchangeName)) {
                return false;
            }
            String this$queueName = this.getQueueName();
            String other$queueName = other.getQueueName();
            if (this$queueName == null ? other$queueName != null : !this$queueName.equals(other$queueName)) {
                return false;
            }
            String this$routingkey = this.getRoutingkey();
            String other$routingkey = other.getRoutingkey();
            if (this$routingkey == null ? other$routingkey != null : !this$routingkey.equals(other$routingkey)) {
                return false;
            }
            Object this$message = this.getMessage();
            Object other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueueBindingBean;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $retryCount = this.getRetryCount();
            result = result * 59 + ($retryCount == null ? 43 : ((Object)$retryCount).hashCode());
            String $exchangeName = this.getExchangeName();
            result = result * 59 + ($exchangeName == null ? 43 : $exchangeName.hashCode());
            String $queueName = this.getQueueName();
            result = result * 59 + ($queueName == null ? 43 : $queueName.hashCode());
            String $routingkey = this.getRoutingkey();
            result = result * 59 + ($routingkey == null ? 43 : $routingkey.hashCode());
            Object $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "RabbitMqHandlerMethodArgumentResolver.QueueBindingBean(exchangeName=" + this.getExchangeName() + ", queueName=" + this.getQueueName() + ", routingkey=" + this.getRoutingkey() + ", message=" + this.getMessage() + ", retryCount=" + this.getRetryCount() + ")";
        }
    }
}

