package com.digiwin.athena.framework.mq.retry;

import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Data
@Configuration
@ConditionalOnProperty(prefix = "athena.mq.retry", name = "enable", havingValue = "true")
@ConfigurationProperties(prefix = "athena.mq.retry")
public class RabbitMqRetryProperties {

    private boolean enable;

    //第一次消费是否异步：是->异步，否-不异步只有重试走异步
    private boolean async;

    private long asyncTimeout = 3000;

    //最大重试次数
    private long maxMQRetryCount = 3;

    private ThreadPoolConfig poolConfig;

    @Data
    public static class ThreadPoolConfig {
        private Integer coreSize = 10;
        private Integer maxSize = 50;
        private Long keepAliveTime = 60L;
        private Integer queueSize = 2000;
        private Long timeOut = 60000L;
    }
}
