package com.digiwin.athena.framework.mq.retry.context;

import com.digiwin.athena.framework.mq.retry.support.RabbitMqHandlerMethodArgumentResolver;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;
import lombok.Data;

public class MQRetryContextHolder {

    private static final JaThreadLocal<MQRetryContext> mqRetryContext = new JaThreadLocal<>();

    private MQRetryContextHolder() {

    }

    public static MQRetryContext getContext() {
        MQRetryContext ctx = mqRetryContext.get();
        if (ctx == null) {
            ctx = createEmptyContext();
            mqRetryContext.set(ctx);
        }
        return ctx;
    }

    private static MQRetryContext createEmptyContext() {
        return new MQRetryContext();
    }

    public static void clearContext() {
        mqRetryContext.remove();
    }

    @Data
    public static class MQRetryContext {
        //        private volatile String msgId;
        private volatile RabbitMqHandlerMethodArgumentResolver.QueueBindingBean queueBinding;
        private volatile int mqRetrycount;
        private volatile int localRetrycount;
        private volatile Throwable lastException;
    }

}
