/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.jugg.agile.middleware.rabbitmq.spring.JaNodeSpanRabbitListenerConsumer;
import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.Assert;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private HandlerAdapter handlerAdapter;
    private final MessagingMessageConverterAdapter messagingMessageConverter;
    private final boolean returnExceptions;
    private final RabbitListenerErrorHandler errorHandler;

    public MessagingMessageListenerAdapter() {
        this(null, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, false, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler) {
        this(bean, method, returnExceptions, errorHandler, false);
    }

    protected MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler, boolean batch) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(this, bean, method, batch);
        this.returnExceptions = returnExceptions;
        this.errorHandler = errorHandler;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }

    protected HandlerAdapter getHandlerAdapter() {
        return this.handlerAdapter;
    }

    public boolean isAsyncReplies() {
        return this.handlerAdapter.isAsyncReplies();
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messagingMessageConverter.setPayloadConverter(messageConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        Message message = null;
        try {
            JaNodeSpanRabbitListenerConsumer.MessageThreadLocal.set((Object)amqpMessage);
            JaNodeSpanRabbitListenerConsumer.ChannelThreadLocal.set((Object)channel);
            message = this.toMessagingMessage(amqpMessage);
            this.invokeHandlerAndProcessResult(amqpMessage, channel, message);
        }
        catch (ListenerExecutionFailedException ex) {
            this.handleException(amqpMessage, channel, message, ex);
        }
        catch (ReplyFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.handleException(amqpMessage, channel, message, new ListenerExecutionFailedException("Failed to convert message", (Throwable)ex, new org.springframework.amqp.core.Message[]{amqpMessage}));
        }
        finally {
            JaNodeSpanRabbitListenerConsumer.MessageThreadLocal.remove();
            JaNodeSpanRabbitListenerConsumer.ChannelThreadLocal.remove();
        }
    }

    private void handleException(org.springframework.amqp.core.Message amqpMessage, Channel channel, @Nullable Message<?> message, ListenerExecutionFailedException e) throws Exception {
        block6: {
            if (this.errorHandler != null) {
                try {
                    Object errorResult;
                    Message messageWithChannel = null;
                    if (message != null) {
                        messageWithChannel = MessageBuilder.fromMessage(message).setHeader("amqp_channel", (Object)channel).build();
                    }
                    if ((errorResult = this.errorHandler.handleError(amqpMessage, messageWithChannel, e)) != null) {
                        Object payload = message == null ? null : message.getPayload();
                        InvocationResult invResult = payload == null ? new InvocationResult(errorResult, null, null, null, null) : this.handlerAdapter.getInvocationResultFor(errorResult, payload);
                        this.handleResult(invResult, amqpMessage, channel, message);
                        break block6;
                    }
                    this.logger.trace((Object)"Error handler returned no result");
                }
                catch (Exception ex) {
                    this.returnOrThrow(amqpMessage, channel, message, (Throwable)ex, ex);
                }
            } else {
                this.returnOrThrow(amqpMessage, channel, message, e.getCause(), (Exception)((Object)e));
            }
        }
    }

    protected void invokeHandlerAndProcessResult(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) throws Exception {
        boolean projectionUsed;
        boolean bl = projectionUsed = amqpMessage == null ? false : amqpMessage.getMessageProperties().isProjectionUsed();
        if (projectionUsed) {
            amqpMessage.getMessageProperties().setProjectionUsed(false);
        }
        if (this.logger.isDebugEnabled() && !projectionUsed) {
            this.logger.debug((Object)("Processing [" + message + "]"));
        }
        InvocationResult result = null;
        if (this.messagingMessageConverter.method == null && amqpMessage != null) {
            amqpMessage.getMessageProperties().setTargetMethod(this.handlerAdapter.getMethodFor(message.getPayload()));
        }
        if ((result = this.invokeHandler(amqpMessage, channel, message)).getReturnValue() != null) {
            this.handleResult(result, amqpMessage, channel, message);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    private void returnOrThrow(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message, Throwable throwableToReturn, Exception exceptionToThrow) throws Exception {
        if (!this.returnExceptions) {
            throw exceptionToThrow;
        }
        Object payload = message == null ? null : message.getPayload();
        try {
            this.handleResult(new InvocationResult((Object)new RemoteInvocationResult(throwableToReturn), null, (Type)(payload == null ? Object.class : this.handlerAdapter.getReturnTypeFor(payload)), this.handlerAdapter.getBean(), payload == null ? null : this.handlerAdapter.getMethodFor(payload)), amqpMessage, channel, message);
        }
        catch (ReplyFailureException rfe) {
            if (payload == null || Void.TYPE.equals(this.handlerAdapter.getReturnTypeFor(payload))) {
                throw exceptionToThrow;
            }
            throw rfe;
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    private InvocationResult invokeHandler(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            if (amqpMessage == null) {
                return this.handlerAdapter.invoke(message, new Object[]{channel});
            }
            return this.handlerAdapter.invoke(message, new Object[]{amqpMessage, channel, amqpMessage.getMessageProperties()});
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), (Throwable)ex, new org.springframework.amqp.core.Message[]{amqpMessage});
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerAdapter.getMethodAsString(message.getPayload()) + "' threw exception", (Throwable)ex, new org.springframework.amqp.core.Message[]{amqpMessage});
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerAdapter.getMethodAsString(payload) + "]\nBean [" + this.handlerAdapter.getBean() + "]";
    }

    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result, Type genericType) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return this.convert(result, genericType, converter);
        }
        if (!(result instanceof org.springframework.amqp.core.Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result + "]");
        }
        return (org.springframework.amqp.core.Message)result;
    }
}

