package com.digiwin.athena.framework.rabbitmq;

import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.io.JaInputStreamUtil;
import com.jugg.agile.framework.core.util.reflect.clazz.loader.JaAppClassLoader;
import com.jugg.agile.framework.meta.handler.JaStartupHookHandler;

import java.io.InputStream;

/**
 * 重写MessagingMessageListenerAdapter, 适配上下文
 *
 * @author chenjian
 * @since 2025年06月25日 14:36:05
 */
public class DwRabbitMQStartupHookHandler implements JaStartupHookHandler {
    @Override
    public void start() {
        try {
//            String sourceCode = JaFileReadUtil.readAsString("sourceCode/MessagingMessageListenerAdapter.java");
//            JaJavaCompilerInMemory.compile("org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter", sourceCode);
            JaLog.info("开始加载org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter");

            try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("mqSourceCode/MessagingMessageListenerAdapter.class")) {
                assert inputStream != null;
                JaAppClassLoader.defineClass("org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter"
                        , JaInputStreamUtil.read3(inputStream));
            } catch (Throwable e) {
                JaLog.error("mqSourceCode/MessagingMessageListenerAdapter.class defineClass error:{}", e.getMessage(), e);
            }
        } catch (Throwable e) {
            JaLog.error("MessagingMessageListenerAdapter compile error", e);
        }


    }
}
