/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.digiwin.athena.framework.rw.DbSwitchConfig;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.contants.WriteType;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import org.apache.ibatis.mapping.BoundSql;

public class MySqlReplaceTableNameVisitor
extends MySqlASTVisitorAdapter {
    private final BoundSql boundSql;
    private boolean anyReplaced = false;
    private ReadType finalReadType = ReadType.OLD;
    private WriteType finalWriteType = WriteType.OLD;
    private DbSwitchConfig dbSwitchConfig;
    private String tableName;

    public MySqlReplaceTableNameVisitor(BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        this.boundSql = boundSql;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public boolean visit(SQLExprTableSource x) {
        AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(x.getExpr().toString());
        this.tableName = x.getExpr().toString();
        shardStrategy.replaceTableName(x, this.boundSql, this.dbSwitchConfig);
        return true;
    }

    public BoundSql getBoundSql() {
        return this.boundSql;
    }

    public boolean isAnyReplaced() {
        return this.anyReplaced;
    }

    public ReadType getFinalReadType() {
        return this.finalReadType;
    }

    public WriteType getFinalWriteType() {
        return this.finalWriteType;
    }

    public DbSwitchConfig getDbSwitchConfig() {
        return this.dbSwitchConfig;
    }

    public String getTableName() {
        return this.tableName;
    }
}

