/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.alibaba.druid.DbType;
import com.alibaba.druid.util.JdbcConstants;
import com.digiwin.athena.framework.rw.DbSwitchConfig;
import com.digiwin.athena.framework.rw.ShardProcessor;
import com.digiwin.athena.framework.rw.router.DataSourRouter;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class ShardPlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ShardPlugin.class);
    private DataSourRouter dataSourRouter;
    private DbSwitchConfig dbSwitchConfig;
    public static final DbType DB_TYPE = JdbcConstants.MYSQL;

    public ShardPlugin(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        this.dataSourRouter = dataSourRouter;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = this.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject(target);
        try {
            MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
            SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
            if (sqlCommandType == SqlCommandType.SELECT) {
                this.processRead(metaObject);
            } else if (Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE, SqlCommandType.DELETE).contains(sqlCommandType)) {
                this.processWrite(metaObject, invocation);
            }
        }
        catch (Exception e) {
            log.error("[shard-plugin] ERROR", (Throwable)e);
        }
        return invocation.proceed();
    }

    private void processRead(MetaObject metaObject) {
        ShardProcessor shardProcessor = new ShardProcessor(metaObject, this.dbSwitchConfig);
        shardProcessor.route();
    }

    private void processWrite(MetaObject metaObject, Invocation invocation) throws SQLException {
        ShardProcessor shardProcessor = new ShardProcessor(metaObject, this.dbSwitchConfig);
        shardProcessor.processParams();
        shardProcessor.processWrite(this.dataSourRouter.getNewDs().getConnection());
    }

    private Object handleDualWrite(Invocation invocation, MetaObject metaObject) throws Throwable {
        Object result = null;
        result = invocation.proceed();
        try {
            invocation.proceed();
        }
        catch (Exception e) {
            log.warn("[shard-plugin] \u53cc\u5199 second \u6570\u636e\u6e90\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return result;
    }

    private <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return this.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    public DataSourRouter getDataSourRouter() {
        return this.dataSourRouter;
    }

    public DbSwitchConfig getDbSwitchConfig() {
        return this.dbSwitchConfig;
    }

    public void setDataSourRouter(DataSourRouter dataSourRouter) {
        this.dataSourRouter = dataSourRouter;
    }

    public void setDbSwitchConfig(DbSwitchConfig dbSwitchConfig) {
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardPlugin)) {
            return false;
        }
        ShardPlugin other = (ShardPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSourRouter this$dataSourRouter = this.getDataSourRouter();
        DataSourRouter other$dataSourRouter = other.getDataSourRouter();
        if (this$dataSourRouter == null ? other$dataSourRouter != null : !((Object)this$dataSourRouter).equals(other$dataSourRouter)) {
            return false;
        }
        DbSwitchConfig this$dbSwitchConfig = this.getDbSwitchConfig();
        DbSwitchConfig other$dbSwitchConfig = other.getDbSwitchConfig();
        return !(this$dbSwitchConfig == null ? other$dbSwitchConfig != null : !((Object)this$dbSwitchConfig).equals(other$dbSwitchConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSourRouter $dataSourRouter = this.getDataSourRouter();
        result = result * 59 + ($dataSourRouter == null ? 43 : ((Object)$dataSourRouter).hashCode());
        DbSwitchConfig $dbSwitchConfig = this.getDbSwitchConfig();
        result = result * 59 + ($dbSwitchConfig == null ? 43 : ((Object)$dbSwitchConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ShardPlugin(dataSourRouter=" + this.getDataSourRouter() + ", dbSwitchConfig=" + this.getDbSwitchConfig() + ")";
    }
}

