/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.framework.rw.DbSwitchConfig;
import com.digiwin.athena.framework.rw.MySqlReplaceTableNameVisitor;
import com.digiwin.athena.framework.rw.ShardPlugin;
import com.digiwin.athena.framework.rw.contants.WriteType;
import com.digiwin.athena.framework.rw.exception.MyBatisShardException;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import com.digiwin.athena.framework.rw.utils.CommonUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ShardProcessor {
    private static final Logger log = LoggerFactory.getLogger(ShardProcessor.class);
    private final MetaObject metaObject;
    private DbSwitchConfig dbSwitchConfig;
    private final BoundSql boundSql;
    private final MappedStatement mappedStatement;
    private final String originalSql;
    private final String shardSql;
    private String tableName;

    public ShardProcessor(@NonNull MetaObject metaObject, DbSwitchConfig dbSwitchConfig) {
        if (metaObject == null) {
            throw new NullPointerException("metaObject is marked non-null but is null");
        }
        this.metaObject = metaObject;
        this.boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        this.mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        this.originalSql = this.boundSql.getSql();
        this.shardSql = this.calculateShardSql();
        this.dbSwitchConfig = dbSwitchConfig;
    }

    private String calculateShardSql() {
        SQLStatement stmt = this.getSqlStatement();
        MySqlReplaceTableNameVisitor mySqlReplaceTableNameVisitor = new MySqlReplaceTableNameVisitor(this.boundSql, this.dbSwitchConfig);
        stmt.accept((SQLASTVisitor)mySqlReplaceTableNameVisitor);
        this.tableName = mySqlReplaceTableNameVisitor.getTableName();
        return SQLUtils.toMySqlString((SQLObject)stmt);
    }

    public void route() {
        this.setShardSql();
    }

    private void setShardSql() {
        this.metaObject.setValue("delegate.boundSql.sql", (Object)this.shardSql);
    }

    public void processParams() {
        SQLStatement stmt = this.getSqlStatement();
        SchemaStatVisitor schemaStatVisitor = SQLUtils.createSchemaStatVisitor((DbType)ShardPlugin.DB_TYPE);
        stmt.accept((SQLASTVisitor)schemaStatVisitor);
        AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(this.tableName);
        shardStrategy.processParams(this.metaObject, this.boundSql, schemaStatVisitor);
    }

    private SQLStatement getSqlStatement() {
        List stmtList = SQLUtils.parseStatements((String)this.originalSql, (DbType)ShardPlugin.DB_TYPE);
        Assert.notEmpty((Collection)stmtList, (String)("stmtList is empty, sql: " + this.originalSql));
        return (SQLStatement)stmtList.get(0);
    }

    public void processWrite(@NonNull Connection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        WriteType writeType = WriteType.valueOfKey(this.dbSwitchConfig.getWriteMode());
        switch (writeType) {
            case OLD: {
                this.setShardSql();
                return;
            }
            case NEW: {
                this.setShardSql();
                return;
            }
            case BOTH: {
                this.writeShard(connection);
                return;
            }
        }
        throw new MyBatisShardException("\u672a\u77e5WriteType\uff1a" + this.dbSwitchConfig.getWriteMode());
    }

    private void writeShard(Connection connection) {
        Object parameterObject = this.boundSql.getParameterObject();
        log.info("[rw-plugin] double write sql: {} \n  parameterObject({}): {}", new Object[]{CommonUtils.removeBreakingWhitespace(this.shardSql), parameterObject.getClass().getSimpleName(), JSON.toJSONString((Object)parameterObject)});
        try (PreparedStatement statement = connection.prepareStatement(this.shardSql);){
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(this.mappedStatement, parameterObject, this.boundSql);
            parameterHandler.setParameters(statement);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new MyBatisShardException(String.format("Error: Method ShardPlugin.write execution error of sql : \n %s \n", CommonUtils.removeBreakingWhitespace(this.shardSql)), e);
        }
    }
}

