/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.strategy;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.digiwin.athena.framework.rw.DbSwitchConfig;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import java.util.Objects;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.util.StringUtils;

public class PtmShardStrategy
extends AbstractShardStrategy {
    private static final String PRIMARY_KEY = "id";

    public PtmShardStrategy(String originalTableName) {
        super(originalTableName);
    }

    @Override
    public boolean replaceTableName(@NonNull SQLExprTableSource x, @NonNull BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (boundSql == null) {
            throw new NullPointerException("boundSql is marked non-null but is null");
        }
        ReadType readType = ReadType.valueOfKey(dbSwitchConfig.getReadMode());
        switch (readType) {
            case OLD: {
                return false;
            }
            case NEW: {
                x.setExpr(this.getShardTableName(boundSql.getParameterObject(), dbSwitchConfig));
                return true;
            }
        }
        return false;
    }

    @Override
    public String getShardTableName(@NonNull Object parameterObject, DbSwitchConfig dbSwitchConfig) {
        if (parameterObject == null) {
            throw new NullPointerException("parameterObject is marked non-null but is null");
        }
        String shardTableName = dbSwitchConfig.getTableMapping().get(super.getOriginalTableName());
        shardTableName = StringUtils.isEmpty((Object)shardTableName) ? super.getOriginalTableName() : shardTableName;
        return shardTableName;
    }

    @Override
    public void processParams(@NonNull MetaObject metaObject, @NonNull BoundSql boundSql, @NonNull SchemaStatVisitor statVisitor) {
        if (metaObject == null) {
            throw new NullPointerException("metaObject is marked non-null but is null");
        }
        if (boundSql == null) {
            throw new NullPointerException("boundSql is marked non-null but is null");
        }
        if (statVisitor == null) {
            throw new NullPointerException("statVisitor is marked non-null but is null");
        }
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!Objects.equals(SqlCommandType.INSERT, mappedStatement.getSqlCommandType())) {
            return;
        }
    }
}

