package com.digiwin.athena.framework.rw.contants;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum WriteType {
    /**
     * 只写旧表
     */
    OLD("old"),
    /**
     * 只写新表
     */
    NEW("new"),
    /**
     * 双写
     */
    BOTH("both");

    private final String key;

    public static WriteType valueOfKey(String key) {
        for (WriteType type : WriteType.values()) {
            if (type.getKey().equalsIgnoreCase(key)) {
                return type;
            }
        }
        throw new IllegalArgumentException("No WriteType constant for key: " + key);
    }
}