package com.digiwin.athena.framework.rw.router;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;

import com.digiwin.athena.framework.rw.RWTypeInterceptor;
import com.digiwin.athena.framework.rw.ShardPlugin;
import lombok.Data;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Data
@Configuration
@EnableConfigurationProperties(DbSwitchConfig.class)
@ConditionalOnProperty(prefix = "athena.dbswitch", name = "enable", havingValue = "true", matchIfMissing = false)
public class DataSourRouterConfig {

    private ApplicationContext applicationContext;
    private DbSwitchConfig dbSwitchConfig;

    public DataSourRouterConfig(ApplicationContext applicationContext,
                                DbSwitchConfig dbSwitchConfig) {
        this.applicationContext = applicationContext;
        this.dbSwitchConfig = dbSwitchConfig;
    }


    @Bean
    public RWTypeInterceptor rwTypeInterceptor(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        return new RWTypeInterceptor(dataSourRouter, dbSwitchConfig);
    }

    @Bean
    public ShardPlugin shardPlugin(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        return new ShardPlugin(dataSourRouter, dbSwitchConfig);
    }


    @Bean
    public MybatisInterceptorInit mybatisInterceptorInit(List<SqlSessionFactory> sqlSessionFactoryList, ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor) {
        return new MybatisInterceptorInit(sqlSessionFactoryList, shardPlugin, rwTypeInterceptor);
    }

//    @PostConstruct
//    public void addMybatisInterceptor(/*ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor*/) {
//        Map<String, SqlSessionFactory> sqlSessionFactoryMap = applicationContext.getBeansOfType(SqlSessionFactory.class);
//        // 获取所有 SqlSessionFactory 实例组成的 List
//        List<SqlSessionFactory> sqlSessionFactoryList = new ArrayList<>(sqlSessionFactoryMap.values());
//
//        RWTypeInterceptor rwTypeInterceptor = applicationContext.getBean(RWTypeInterceptor.class);
//        ShardPlugin shardPlugin = applicationContext.getBean(ShardPlugin.class);
//
//        for (SqlSessionFactory sqlSessionFactory : sqlSessionFactoryList) {
//            org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
//            configuration.addInterceptor(shardPlugin);
//            configuration.addInterceptor(rwTypeInterceptor);
//        }
//    }

//    @Bean
//    public ConfigurationCustomizer configurationCustomizer(ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor) {
//        return configuration -> {
//            // 添加拦截器
//            configuration.addInterceptor(shardPlugin);
//            configuration.addInterceptor(rwTypeInterceptor);
//            // 开启驼峰命名映射
//            configuration.setMapUnderscoreToCamelCase(true);
//        };
//    }

    @Bean(name = "dataSourRouter")
    public DataSourRouter dataSourRouter() {
        String oldName = dbSwitchConfig.getOldDatasourceName();
        String newName = dbSwitchConfig.getNewDatasourceName();

        DataSource oldDs = getDataSourceByBeanName(oldName);
        DataSource newDs = getDataSourceByBeanName(newName);

        DataSourRouter dataSourRouter = new DataSourRouter(oldDs, newDs);
        return dataSourRouter;
    }

    private DataSource getDataSourceByBeanName(String beanName) {
        if (!applicationContext.containsBean(beanName)) {
            throw new IllegalArgumentException("数据源Bean不存在: " + beanName);
        }
        Object bean = applicationContext.getBean(beanName);
        if (!(bean instanceof DataSource)) {
            throw new IllegalArgumentException("Bean不是DataSource类型: " + beanName);
        }
        return (DataSource) bean;
    }

}
