package com.digiwin.athena.framework.rw.router;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.contants.WriteType;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import lombok.Getter;
import org.apache.ibatis.mapping.BoundSql;

@Getter
//@RequiredArgsConstructor
public class MySqlReplaceTableNameVisitor extends MySqlASTVisitorAdapter {
    private final BoundSql boundSql;
    private boolean anyReplaced = false;
    private ReadType finalReadType = ReadType.OLD;
    private WriteType finalWriteType = WriteType.OLD;
    private DbSwitchConfig dbSwitchConfig;
    private String tableName;

    public MySqlReplaceTableNameVisitor(BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        this.boundSql = boundSql;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(x.getExpr().toString());
        //todo 加入读写标志获取及写入
        tableName = x.getExpr().toString();
        shardStrategy.replaceTableName(x, boundSql, dbSwitchConfig);
        return true;
    }

}
