package com.digiwin.athena.framework.rw.router;

import com.digiwin.athena.framework.rw.RWTypeInterceptor;
import com.digiwin.athena.framework.rw.ShardPlugin;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

//@Configuration
//@ConfigurationProperties(prefix = "athena.dbswitch")
//@ConditionalOnProperty(prefix = "athena.dbswitch", name = "enable", havingValue = "true", matchIfMissing = false)
public class MybatisInterceptorInit {

//    private ApplicationContext applicationContext;
//
//    public MybatisInterceptorInit(ApplicationContext applicationContext) {
//        this.applicationContext = applicationContext;
//    }

    private List<SqlSessionFactory> sqlSessionFactoryList;
    private ShardPlugin shardPlugin;
    private RWTypeInterceptor rwTypeInterceptor;

    MybatisInterceptorInit(List<SqlSessionFactory> sqlSessionFactoryList, ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
        this.shardPlugin = shardPlugin;
        this.rwTypeInterceptor = rwTypeInterceptor;
    }

//    @PostConstruct
//    public void addMybatisInterceptor() {
////        Map<String, SqlSessionFactory> sqlSessionFactoryMap = applicationContext.getBeansOfType(SqlSessionFactory.class);
////        // 获取所有 SqlSessionFactory 实例组成的 List
////        List<SqlSessionFactory> sqlSessionFactoryList = new ArrayList<>(sqlSessionFactoryMap.values());
//
////        RWTypeInterceptor rwTypeInterceptor = applicationContext.getBean(RWTypeInterceptor.class);
////        ShardPlugin shardPlugin = applicationContext.getBean(ShardPlugin.class);
//
//        for (SqlSessionFactory sqlSessionFactory : sqlSessionFactoryList) {
//            org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
//            configuration.addInterceptor(shardPlugin);
//            configuration.addInterceptor(rwTypeInterceptor);
//        }
//    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer(RWTypeInterceptor rwTypeInterceptor, ShardPlugin shardPlugin) {
        return configuration -> {
            configuration.addInterceptor(shardPlugin);
            configuration.addInterceptor(rwTypeInterceptor);
        };
    }

}
