package com.digiwin.athena.framework.rw;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.spring.boot.core.config.JaSpringPropertyProcessor;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

@Slf4j
public class RWSetUpConfigUpdater implements InitializingBean {
    @Override
    public void afterPropertiesSet() throws Exception {
        // 更新 RWSetUpConfig 中的配置
        nacosUpdate();
    }

    public void nacosUpdate() {
        JaPropertyListener.addCommonListener(() -> {
            DbSwitchConfig tempProperties = JaSpringBeanUtil.getBean(DbSwitchConfig.class);
            log.warn("ccp before nacosUpdate:{}" + JSON.toJSONString(tempProperties));
            JaSpringPropertyProcessor.refresh(DbSwitchConfig.class);
            DbSwitchConfig dbSwitchConfig = JaSpringBeanUtil.getBean(DbSwitchConfig.class);
            log.warn("ccp after nacosUpdate:{}" + JSON.toJSONString(dbSwitchConfig));
        });
    }
}
