package com.digiwin.athena.framework.rw.strategy;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.dto.ReadWriterDto;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.utils.IdGenerator;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.util.StringUtils;

import java.util.Objects;

public class DefaultShardStrategy extends AbstractShardStrategy {

    private static final String PRIMARY_KEY = "id";
    public static final String TABLE_NAME = "_DEFAULT";

    public static final DefaultShardStrategy INSTANCE = new DefaultShardStrategy(TABLE_NAME);

    public DefaultShardStrategy(String originalTableName) {
        super(originalTableName);
    }

    @Override
    public void processParams(@NonNull MetaObject metaObject, @NonNull BoundSql boundSql, @NonNull SchemaStatVisitor statVisitor) {
        MappedStatement mappedStatement = (MappedStatement) metaObject.getValue("delegate.mappedStatement");
        if (!Objects.equals(SqlCommandType.INSERT, mappedStatement.getSqlCommandType())) {
            return;
        }
        setColumnValue(boundSql, PRIMARY_KEY, statVisitor.getColumns(), IdGenerator::getSnowflakeId);
    }

    @Override
    public void processBefore(ReadWriterDto readWriterDto) {

    }
}