/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.router;

import com.digiwin.athena.framework.rw.RWTypeInterceptor;
import com.digiwin.athena.framework.rw.ShardPlugin;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MybatisInterceptorInit
implements ApplicationContextAware {
    private List<SqlSessionFactory> sqlSessionFactoryList;
    private ShardPlugin shardPlugin;
    private RWTypeInterceptor rwTypeInterceptor;
    private ApplicationContext applicationContext;

    MybatisInterceptorInit(List<SqlSessionFactory> sqlSessionFactoryList, ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
        this.shardPlugin = shardPlugin;
        this.rwTypeInterceptor = rwTypeInterceptor;
    }

    @PostConstruct
    public void addMybatisInterceptor() {
        Map dataSourceMap = this.applicationContext.getBeansOfType(DataSource.class);
        block0: for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            Configuration configuration = sqlSessionFactory.getConfiguration();
            Environment environment = configuration.getEnvironment();
            DataSource currentDataSource = environment.getDataSource();
            for (Map.Entry entry : dataSourceMap.entrySet()) {
                String beanName = (String)entry.getKey();
                DataSource dataSource = (DataSource)entry.getValue();
                if (!"ptmPrimaryDataSource".equals(beanName) && (!"ptmPrimaryDataSource".equals(beanName) || dataSource != currentDataSource)) continue;
                configuration.addInterceptor((Interceptor)this.shardPlugin);
                configuration.addInterceptor((Interceptor)this.rwTypeInterceptor);
                continue block0;
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

