/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.strategy;

import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.digiwin.athena.framework.rw.dto.ReadWriterDto;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.utils.IdGenerator;
import java.util.Objects;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;

public class DefaultShardStrategy
extends AbstractShardStrategy {
    private static final String PRIMARY_KEY = "id";
    public static final String TABLE_NAME = "_DEFAULT";
    public static final DefaultShardStrategy INSTANCE = new DefaultShardStrategy("_DEFAULT");

    public DefaultShardStrategy(String originalTableName) {
        super(originalTableName);
    }

    @Override
    public void processParams(@NonNull MetaObject metaObject, @NonNull BoundSql boundSql, @NonNull SchemaStatVisitor statVisitor) {
        if (metaObject == null) {
            throw new NullPointerException("metaObject is marked non-null but is null");
        }
        if (boundSql == null) {
            throw new NullPointerException("boundSql is marked non-null but is null");
        }
        if (statVisitor == null) {
            throw new NullPointerException("statVisitor is marked non-null but is null");
        }
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!Objects.equals(SqlCommandType.INSERT, mappedStatement.getSqlCommandType())) {
            return;
        }
        this.setColumnValue(boundSql, PRIMARY_KEY, statVisitor.getColumns(), IdGenerator::getSnowflakeId);
    }

    @Override
    public void processBefore(ReadWriterDto readWriterDto) {
    }
}

