/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.stat.TableStat;
import com.digiwin.athena.framework.rw.ShardPlugin;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class Test {
    public static void main(String[] args) {
        List<SQLStatement> stmtList = Test.getSqlStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        stmtList.get(0).accept((SQLASTVisitor)visitor);
        Set tableNames = visitor.getTables().keySet();
        final HashMap<String, String> tableNameReplaceMap = new HashMap<String, String>();
        for (TableStat.Name name : tableNames) {
            String originalTableName = name.getName();
            String shardTableName = Test.getShardTableName(originalTableName);
            tableNameReplaceMap.put(originalTableName, shardTableName);
        }
        for (SQLStatement stmt : stmtList) {
            stmt.accept((SQLASTVisitor)new SQLASTVisitorAdapter(){

                public boolean visit(SQLExprTableSource x) {
                    String oldName = x.getExpr().toString();
                    System.out.println("sss:" + ShardStrategyContext.handleName(oldName));
                    if (tableNameReplaceMap.containsKey(oldName)) {
                        x.setExpr((SQLExpr)new SQLIdentifierExpr((String)tableNameReplaceMap.get(oldName)));
                    }
                    return true;
                }
            });
        }
        String ssss = SQLUtils.toMySqlString((SQLObject)((SQLObject)stmtList.get(0)));
        System.out.println("====>" + ssss);
        String originalSql = "SELECT a.name, b.age FROM user a JOIN user_detail b ON a.id = b.user_id WHERE b.age > 18";
        List stmtList1111 = SQLUtils.parseStatements((String)originalSql, (DbType)ShardPlugin.DB_TYPE);
        System.out.println("------->" + ((SQLStatement)stmtList1111.get(0)).toString());
    }

    private static List<SQLStatement> getSqlStatement() {
        String originalSql = "SELECT a.name, b.age FROM `user` a JOIN user_detail b ON a.id = b.user_id WHERE b.age > 18";
        List stmtList = SQLUtils.parseStatements((String)originalSql, (DbType)ShardPlugin.DB_TYPE);
        Assert.notEmpty((Collection)stmtList, (String)("stmtList is empty, sql: " + originalSql));
        return stmtList;
    }

    private static String getShardTableName(String tableName) {
        if ("user".equals(tableName)) {
            return "user_new111";
        }
        if ("user_detail".equals(tableName)) {
            return "user_detail111";
        }
        return null;
    }
}

