/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.strategy;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.framework.rw.exception.MyBatisShardException;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.util.StringUtils;

public abstract class AbstractShardStrategy {
    private final String originalTableName;

    public AbstractShardStrategy(String originalTableName) {
        this.originalTableName = originalTableName;
    }

    protected String getOriginalTableName() {
        return this.originalTableName;
    }

    public boolean replaceTableName(@NonNull SQLExprTableSource sqlExprTableSource, @NonNull BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        if (sqlExprTableSource == null) {
            throw new NullPointerException("sqlExprTableSource is marked non-null but is null");
        }
        if (boundSql == null) {
            throw new NullPointerException("boundSql is marked non-null but is null");
        }
        sqlExprTableSource.setExpr(this.getShardTableName(dbSwitchConfig));
        return false;
    }

    public String getShardTableName(DbSwitchConfig dbSwitchConfig) {
        String shardTableName = dbSwitchConfig.getTableMapping().get(ShardStrategyContext.handleName(this.getOriginalTableName()));
        shardTableName = StringUtils.isEmpty((Object)shardTableName) ? this.getOriginalTableName() : shardTableName;
        return shardTableName;
    }

    public abstract void processParams(@NonNull MetaObject var1, @NonNull BoundSql var2, @NonNull SchemaStatVisitor var3);

    public void register() {
        ShardStrategyContext.registerStrategy(this.getOriginalTableName(), this);
    }

    protected void setColumnValue(BoundSql boundSql, String columnName, Collection<TableStat.Column> columns, Supplier<Object> supplier) {
        boolean findColumn = false;
        for (TableStat.Column column : columns) {
            if (!Objects.equals(column.getName(), columnName)) continue;
            findColumn = true;
            break;
        }
        if (!findColumn) {
            return;
        }
        Object parameterObject = boundSql.getParameterObject();
        if (parameterObject instanceof Map) {
            if (((Map)parameterObject).containsKey(columnName)) {
                ((Map)parameterObject).computeIfAbsent(columnName, k -> supplier.get());
                return;
            }
            Set entrySet = ((Map)parameterObject).entrySet();
            for (Map.Entry entry : entrySet) {
                Object value = entry.getValue();
                if (!(value instanceof Collection)) continue;
                for (Object o : (Collection)value) {
                    this.setNx(o, columnName, supplier);
                }
                return;
            }
            return;
        }
        this.setNx(parameterObject, columnName, supplier);
    }

    private void setNx(@NonNull Object o, @NonNull String key, Supplier<Object> supplier) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (Objects.nonNull(ReflectUtil.getFieldValue((Object)o, (String)key))) {
            return;
        }
        ReflectUtil.setFieldValue((Object)o, (String)key, (Object)supplier.get());
    }

    protected Object getValue(@NonNull Object parameterObject, @NonNull String key) {
        if (parameterObject == null) {
            throw new NullPointerException("parameterObject is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (parameterObject instanceof Map) {
            if (((Map)parameterObject).containsKey(key)) {
                return ((Map)parameterObject).get(key);
            }
            Set entrySet = ((Map)parameterObject).entrySet();
            for (Map.Entry entry : entrySet) {
                Iterator iterator;
                Object value = entry.getValue();
                if (ReflectUtil.hasField(value.getClass(), (String)key)) {
                    return ReflectUtil.getFieldValue(value, (String)key);
                }
                if (!(value instanceof Collection) || !(iterator = ((Collection)value).iterator()).hasNext()) continue;
                Object o = iterator.next();
                return ReflectUtil.getFieldValue(o, (String)key);
            }
            this.throwEx(parameterObject, key);
        }
        return ReflectUtil.getFieldValue((Object)parameterObject, (String)key);
    }

    private void throwEx(@NonNull Object parameterObject, @NonNull String key) {
        if (parameterObject == null) {
            throw new NullPointerException("parameterObject is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        throw new MyBatisShardException(String.format("Error: Method AbstractShardStrategy.getValue, parameterObject(%s): %s, key: %s", parameterObject.getClass().getSimpleName(), JSON.toJSONString((Object)parameterObject), key));
    }
}

