package com.digiwin.athena.framework.rw;

import com.digiwin.athena.framework.rw.router.DataSourRouter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.util.CollectionUtils;

import java.util.List;

public abstract class BaseInterceptor implements Interceptor {

    protected DataSourRouter dataSourRouter;

    protected DbSwitchConfig dbSwitchConfig;


    protected boolean shouldIntercept(String className) {
        List<String> basePackages = dbSwitchConfig.getMapperBasePackages();
        if (!CollectionUtils.isEmpty(basePackages)) {
            return basePackages.stream().anyMatch(className::startsWith);
        }
        return true;
    }

    protected String getMapperClassName(String mappedStatementId) {
        if (mappedStatementId == null) {
            return "";
        }
        int lastDotIndex = mappedStatementId.lastIndexOf('.');
        return lastDotIndex != -1 ? mappedStatementId.substring(0, lastDotIndex) : mappedStatementId;
    }

}
