/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.digiwin.athena.framework.rw.BaseInterceptor;
import com.digiwin.athena.framework.rw.context.RWContextHolder;
import com.digiwin.athena.framework.rw.dto.ReadWriterDto;
import com.digiwin.athena.framework.rw.router.DataSourRouter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import java.util.Arrays;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class RWTypeInterceptor
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RWTypeInterceptor.class);

    public RWTypeInterceptor(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] objects = invocation.getArgs();
        MappedStatement ms = (MappedStatement)objects[0];
        String mapperClassName = this.getMapperClassName(ms.getId());
        boolean shouldIntercept = this.shouldIntercept(mapperClassName);
        if (!shouldIntercept) {
            return invocation.proceed();
        }
        SqlCommandType sqlCommandType = ms.getSqlCommandType();
        if (sqlCommandType == SqlCommandType.SELECT) {
            RWContextHolder.setDataSourceType(new ReadWriterDto(true, this.dbSwitchConfig.getReadMode()));
        } else if (Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE, SqlCommandType.DELETE).contains(sqlCommandType)) {
            RWContextHolder.setDataSourceType(new ReadWriterDto(false, this.dbSwitchConfig.getWriteMode()));
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

